/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.Arrays;

public class EnergyPlotter
implements Configurable {
    @S4Integer(defaultValue=20)
    public static final String PROP_MAX_ENERGY = "maxEnergy";
    private int maxEnergy;
    private String[] plots;

    public EnergyPlotter(int maxEnergy) {
        this.maxEnergy = maxEnergy;
        this.buildPlots(maxEnergy);
    }

    public EnergyPlotter() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.maxEnergy = ps.getInt(PROP_MAX_ENERGY);
        this.buildPlots(this.maxEnergy);
    }

    private void buildPlots(int maxEnergy) {
        this.plots = new String[maxEnergy + 1];
        int i = 0;
        while (i < maxEnergy + 1) {
            this.plots[i] = this.getPlotString(i);
            ++i;
        }
    }

    private String getPlotString(int energy) {
        char[] plot = new char[energy];
        Arrays.fill(plot, '.');
        if (energy > 0) {
            if (energy < 10) {
                plot[plot.length - 1] = (char)(48 + energy);
            } else {
                plot[plot.length - 2] = 49;
                plot[plot.length - 1] = (char)(48 + (energy - 10));
            }
        }
        return String.valueOf('+') + new String(plot);
    }

    public void plot(Data cepstrum) {
        if (cepstrum != null) {
            if (cepstrum instanceof DoubleData) {
                int energy = (int)((DoubleData)cepstrum).getValues()[0];
                System.out.println(this.getPlot(energy));
            } else {
                System.out.println(cepstrum);
            }
        }
    }

    private String getPlot(int energy) {
        if (energy < 0) {
            return "-";
        }
        if (energy <= this.maxEnergy) {
            return this.plots[energy];
        }
        return this.getPlotString(energy);
    }
}

