/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.util.Utilities;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class DataUtil {
    private static final int HEXADECIMAL = 1;
    private static final int SCIENTIFIC = 2;
    private static final int DECIMAL = 3;
    private static final DecimalFormat format = new DecimalFormat();
    private static final int decimalIntegerDigits = 10;
    private static final int decimalFractionDigits = 5;
    private static final int floatScientificFractionDigits = 8;
    private static final int doubleScientificFractionDigits = 8;
    private static int dumpFormat = 2;

    static {
        String formatProperty = System.getProperty("frontend.util.dumpformat", "SCIENTIFIC");
        if (formatProperty.compareToIgnoreCase("DECIMAL") == 0) {
            dumpFormat = 3;
        } else if (formatProperty.compareToIgnoreCase("HEXADECIMAL") == 0) {
            dumpFormat = 1;
        } else if (formatProperty.compareToIgnoreCase("SCIENTIFIC") == 0) {
            dumpFormat = 2;
        }
    }

    private DataUtil() {
    }

    public static short[] byteToShortArray(byte[] byteArray, int offset, int length) throws ArrayIndexOutOfBoundsException {
        if (length > 0 && offset + length <= byteArray.length) {
            int shortLength = length / 2;
            short[] shortArray = new short[shortLength];
            int i = offset;
            int j = 0;
            while (j < shortLength) {
                int temp = byteArray[i++] << 8;
                shortArray[j] = (short)(temp |= 0xFF & byteArray[i++]);
                ++j;
                temp = 0;
            }
            return shortArray;
        }
        throw new ArrayIndexOutOfBoundsException("offset: " + offset + ", length: " + length + ", array length: " + byteArray.length);
    }

    public static double[] bytesToValues(byte[] byteArray, int offset, int length, int bytesPerValue, boolean signedData) throws ArrayIndexOutOfBoundsException {
        if (length > 0 && offset + length <= byteArray.length) {
            assert (length % bytesPerValue == 0);
            double[] doubleArray = new double[length / bytesPerValue];
            int i = offset;
            int j = 0;
            while (j < doubleArray.length) {
                int val = byteArray[i++];
                if (!signedData) {
                    val &= 0xFF;
                }
                int c = 1;
                while (c < bytesPerValue) {
                    int temp = byteArray[i++] & 0xFF;
                    val = (val << 8) + temp;
                    ++c;
                }
                doubleArray[j] = val;
                ++j;
            }
            return doubleArray;
        }
        throw new ArrayIndexOutOfBoundsException("offset: " + offset + ", length: " + length + ", array length: " + byteArray.length);
    }

    public static double[] littleEndianBytesToValues(byte[] data, int offset, int length, int bytesPerValue, boolean signedData) throws ArrayIndexOutOfBoundsException {
        if (length > 0 && offset + length <= data.length) {
            assert (length % bytesPerValue == 0);
            double[] doubleArray = new double[length / bytesPerValue];
            int i = offset + bytesPerValue - 1;
            int j = 0;
            while (j < doubleArray.length) {
                int val = data[i--];
                if (!signedData) {
                    val &= 0xFF;
                }
                int c = 1;
                while (c < bytesPerValue) {
                    int temp = data[i--] & 0xFF;
                    val = (val << 8) + temp;
                    ++c;
                }
                i += bytesPerValue * 2;
                doubleArray[j] = val;
                ++j;
            }
            return doubleArray;
        }
        throw new ArrayIndexOutOfBoundsException("offset: " + offset + ", length: " + length + ", array length: " + data.length);
    }

    public static short bytesToShort(byte[] byteArray, int offset) throws ArrayIndexOutOfBoundsException {
        short result = (short)(byteArray[offset++] << 8 | 0xFF & byteArray[offset]);
        return result;
    }

    public static String shortArrayToString(short[] data) {
        StringBuilder dump = new StringBuilder().append(data.length);
        short[] sArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            short val = sArray[n2];
            dump.append(' ').append(val);
            ++n2;
        }
        return dump.toString();
    }

    public static String doubleArrayToString(double[] data) {
        return DataUtil.doubleArrayToString(data, dumpFormat);
    }

    private static String doubleArrayToString(double[] data, int format) {
        StringBuilder dump = new StringBuilder().append(data.length);
        double[] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double val = dArray[n2];
            if (format == 3) {
                dump.append(' ').append(DataUtil.formatDouble(val, 10, 5));
            } else if (format == 1) {
                long binary = Double.doubleToRawLongBits(val);
                dump.append(" 0x").append(Long.toHexString(binary));
            } else if (format == 2) {
                dump.append(' ').append(Utilities.doubleToScientificString(val, 8));
            }
            ++n2;
        }
        return dump.toString();
    }

    public static String floatArrayToString(float[] data) {
        return DataUtil.floatArrayToString(data, dumpFormat);
    }

    private static String floatArrayToString(float[] data, int format) {
        StringBuilder dump = new StringBuilder().append(data.length);
        float[] fArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            float val = fArray[n2];
            if (format == 3) {
                dump.append(' ').append(DataUtil.formatDouble(val, 10, 5));
            } else if (format == 1) {
                int binary = Float.floatToRawIntBits(val);
                dump.append(" 0x").append(Integer.toHexString(binary));
            } else if (format == 2) {
                dump.append(' ').append(Utilities.doubleToScientificString(val, 8));
            }
            ++n2;
        }
        return dump.toString();
    }

    public static String formatDouble(double number, int integerDigits, int fractionDigits) {
        StringBuilder formatter = new StringBuilder(2 + fractionDigits).append("0.");
        int i = 0;
        while (i < fractionDigits) {
            formatter.append('0');
            ++i;
        }
        format.applyPattern(formatter.toString());
        String formatted = format.format(number);
        int dotIndex = formatted.indexOf(46);
        if (dotIndex == -1) {
            formatted = String.valueOf(formatted) + ".";
            dotIndex = formatted.length() - 1;
        }
        StringBuilder result = new StringBuilder();
        int i2 = dotIndex;
        while (i2 < integerDigits) {
            result.append(' ');
            ++i2;
        }
        result.append(formatted);
        return result.toString();
    }

    public static int getSamplesPerWindow(int sampleRate, float windowSizeInMs) {
        return (int)((float)sampleRate * windowSizeInMs / 1000.0f);
    }

    public static int getSamplesPerShift(int sampleRate, float windowShiftInMs) {
        return (int)((float)sampleRate * windowShiftInMs / 1000.0f);
    }

    public static void bytesToFile(byte[] data, String filename) throws IOException {
        FileOutputStream file = new FileOutputStream(filename);
        file.write(data);
        file.close();
    }

    public static AudioFormat getNativeAudioFormat(AudioFormat format) {
        return DataUtil.getNativeAudioFormat(format, null);
    }

    public static AudioFormat getNativeAudioFormat(AudioFormat format, Mixer mixer) {
        Line.Info[] lineInfos = mixer != null ? mixer.getTargetLineInfo(new Line.Info(TargetDataLine.class)) : AudioSystem.getTargetLineInfo(new Line.Info(TargetDataLine.class));
        AudioFormat nativeFormat = null;
        Line.Info[] infoArray = lineInfos;
        int n = lineInfos.length;
        int n2 = 0;
        while (n2 < n) {
            AudioFormat[] formats;
            Line.Info info = infoArray[n2];
            AudioFormat[] audioFormatArray = formats = ((DataLine.Info)info).getFormats();
            int n3 = formats.length;
            int n4 = 0;
            while (n4 < n3) {
                AudioFormat thisFormat = audioFormatArray[n4];
                if (thisFormat.getEncoding() == format.getEncoding() && thisFormat.isBigEndian() == format.isBigEndian() && thisFormat.getSampleSizeInBits() == format.getSampleSizeInBits() && thisFormat.getSampleRate() >= format.getSampleRate()) {
                    nativeFormat = thisFormat;
                    break;
                }
                ++n4;
            }
            if (nativeFormat != null) break;
            ++n2;
        }
        return nativeFormat;
    }

    public static DoubleData FloatData2DoubleData(FloatData data) {
        int numSamples = data.getValues().length;
        double[] doubleData = new double[numSamples];
        float[] values = data.getValues();
        int i = 0;
        while (i < values.length) {
            doubleData[i] = values[i];
            ++i;
        }
        return new DoubleData(doubleData, data.getSampleRate(), data.getFirstSampleNumber());
    }

    public static FloatData DoubleData2FloatData(DoubleData data) {
        int numSamples = data.getValues().length;
        float[] floatData = new float[numSamples];
        double[] values = data.getValues();
        int i = 0;
        while (i < values.length) {
            floatData[i] = (float)values[i];
            ++i;
        }
        return new FloatData(floatData, data.getSampleRate(), data.getFirstSampleNumber());
    }
}

