/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.util.StreamDataSource;
import edu.cmu.sphinx.util.BatchFile;
import edu.cmu.sphinx.util.ReferenceSource;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class ConcatFileDataSource
extends StreamDataSource
implements ReferenceSource {
    @S4Integer(defaultValue=1)
    public static final String PROP_START_FILE = "startFile";
    @S4Integer(defaultValue=0)
    public static final String PROP_SKIP = "skip";
    @S4Integer(defaultValue=-1)
    public static final String PROP_TOTAL_FILES = "totalFiles";
    @S4String
    public static final String PROP_SILENCE_FILE = "silenceFile";
    @S4Boolean(defaultValue=false)
    public static final String PROP_ADD_RANDOM_SILENCE = "addRandomSilence";
    @S4Integer(defaultValue=3)
    public static final String PROP_MAX_SILENCE = "maxSilence";
    @S4String
    public static final String PROP_TRANSCRIPT_FILE = "transcriptFile";
    @S4String
    public static final String PROP_BATCH_FILE = "batchFile";
    private static final String GAP_LABEL = "inter_segment_gap";
    private boolean addRandomSilence;
    private int skip;
    private int maxSilence;
    private int silenceCount;
    private int bytesPerSecond;
    private long totalBytes;
    private long silenceFileLength;
    private String silenceFileName;
    private String nextFile;
    private String context;
    private String transcriptFile;
    private List<String> referenceList;
    private FileWriter transcript;
    private int startFile;
    private int totalFiles;
    private String batchFile;

    public ConcatFileDataSource(int sampleRate, int bytesPerRead, int bitsPerSample, boolean bigEndian, boolean signedData, boolean addRandomSilence, int maxSilence, int skip, String silenceFileName, int startFile, int totalFiles, String transcriptFile, String batchFile) {
        super(sampleRate, bytesPerRead, bitsPerSample, bigEndian, signedData);
        this.bytesPerSecond = sampleRate * (bitsPerSample / 8);
        this.addRandomSilence = addRandomSilence;
        this.maxSilence = maxSilence;
        this.skip = skip;
        this.silenceFileName = silenceFileName;
        this.startFile = startFile;
        this.totalFiles = totalFiles;
        this.transcriptFile = transcriptFile;
        this.batchFile = batchFile;
    }

    public ConcatFileDataSource() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.bytesPerSecond = this.sampleRate * (this.bitsPerSample / 8);
        this.addRandomSilence = ps.getBoolean(PROP_ADD_RANDOM_SILENCE);
        this.maxSilence = ps.getInt(PROP_MAX_SILENCE);
        this.skip = ps.getInt(PROP_SKIP);
        this.silenceFileName = ps.getString(PROP_SILENCE_FILE);
        this.startFile = ps.getInt(PROP_START_FILE);
        this.totalFiles = ps.getInt(PROP_TOTAL_FILES);
        this.transcriptFile = ps.getString(PROP_TRANSCRIPT_FILE);
        this.batchFile = ps.getString(PROP_BATCH_FILE);
    }

    @Override
    public void initialize() {
        super.initialize();
        try {
            File silenceFile = new File(this.silenceFileName);
            this.silenceFileLength = silenceFile.length();
            if (this.transcriptFile != null) {
                this.transcript = new FileWriter(this.transcriptFile);
            }
            if (this.batchFile == null) {
                throw new Error("BatchFile cannot be null!");
            }
            this.setInputStream(new SequenceInputStream(new InputStreamEnumeration(this.batchFile, this.startFile, this.totalFiles)));
            this.referenceList = new LinkedList<String>();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<String> getReferences() {
        return this.referenceList;
    }

    public String getTranscriptFile() {
        return this.transcriptFile;
    }

    private float getSeconds(long bytes) {
        return (float)bytes / (float)this.bytesPerSecond;
    }

    class InputStreamEnumeration
    implements Enumeration<InputStream> {
        private final int totalFiles;
        private boolean inSilence;
        private Random silenceRandom;
        private BufferedReader reader;

        InputStreamEnumeration(String batchFile, int startFile, int totalFiles) throws IOException {
            this.totalFiles = totalFiles;
            this.reader = new BufferedReader(new FileReader(batchFile));
            if (ConcatFileDataSource.this.silenceFileName != null) {
                this.inSilence = true;
                this.silenceRandom = new Random(System.currentTimeMillis());
                ConcatFileDataSource.this.silenceCount = this.getSilenceCount();
            }
            int i = 1;
            while (i < startFile) {
                this.reader.readLine();
                ++i;
            }
        }

        @Override
        public boolean hasMoreElements() {
            if (ConcatFileDataSource.this.nextFile == null) {
                ConcatFileDataSource.this.nextFile = this.readNext();
            }
            return ConcatFileDataSource.this.nextFile != null;
        }

        @Override
        public InputStream nextElement() {
            FileInputStream stream = null;
            if (ConcatFileDataSource.this.nextFile == null) {
                ConcatFileDataSource.this.nextFile = this.readNext();
            }
            if (ConcatFileDataSource.this.nextFile != null) {
                try {
                    stream = new FileInputStream(ConcatFileDataSource.this.nextFile);
                    ConcatFileDataSource.this.nextFile = null;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    throw new Error("Cannot convert " + ConcatFileDataSource.this.nextFile + " to a FileInputStream");
                }
            }
            if (stream == null && ConcatFileDataSource.this.transcript != null) {
                try {
                    ConcatFileDataSource.this.transcript.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            return stream;
        }

        public String readNext() {
            if (!this.inSilence) {
                return this.readNextDataFile();
            }
            String next = null;
            if (ConcatFileDataSource.this.silenceCount > 0) {
                next = ConcatFileDataSource.this.silenceFileName;
                if (ConcatFileDataSource.this.transcript != null) {
                    this.writeSilenceToTranscript();
                }
                ConcatFileDataSource concatFileDataSource = ConcatFileDataSource.this;
                concatFileDataSource.silenceCount = concatFileDataSource.silenceCount - 1;
                if (ConcatFileDataSource.this.silenceCount <= 0) {
                    this.inSilence = false;
                }
            }
            return next;
        }

        private String readNextDataFile() {
            block7: {
                if (this.totalFiles < 0 || this.totalFiles > ConcatFileDataSource.this.referenceList.size()) break block7;
                return null;
            }
            try {
                String next = this.reader.readLine();
                if (next != null) {
                    String reference = BatchFile.getReference(next);
                    ConcatFileDataSource.this.referenceList.add(reference);
                    next = BatchFile.getFilename(next);
                    int i = 1;
                    while (i < ConcatFileDataSource.this.skip) {
                        this.reader.readLine();
                        ++i;
                    }
                    if (ConcatFileDataSource.this.silenceFileName != null && ConcatFileDataSource.this.maxSilence > 0) {
                        ConcatFileDataSource.this.silenceCount = this.getSilenceCount();
                        this.inSilence = true;
                    }
                    if (ConcatFileDataSource.this.transcript != null) {
                        this.writeTranscript(next, reference);
                    }
                }
                return next;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new Error("Problem reading from batch file");
            }
        }

        private void writeTranscript(String fileName, String reference) {
            try {
                File file = new File(fileName);
                float start = ConcatFileDataSource.this.getSeconds(ConcatFileDataSource.this.totalBytes);
                ConcatFileDataSource concatFileDataSource = ConcatFileDataSource.this;
                concatFileDataSource.totalBytes = concatFileDataSource.totalBytes + file.length();
                float end = ConcatFileDataSource.this.getSeconds(ConcatFileDataSource.this.totalBytes);
                ConcatFileDataSource.this.transcript.write(String.valueOf(ConcatFileDataSource.this.context) + " 1 " + fileName + ' ' + start + ' ' + end + "  " + reference + '\n');
                ConcatFileDataSource.this.transcript.flush();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        private void writeSilenceToTranscript() {
            try {
                float start = ConcatFileDataSource.this.getSeconds(ConcatFileDataSource.this.totalBytes);
                ConcatFileDataSource concatFileDataSource = ConcatFileDataSource.this;
                concatFileDataSource.totalBytes = concatFileDataSource.totalBytes + ConcatFileDataSource.this.silenceFileLength;
                float end = ConcatFileDataSource.this.getSeconds(ConcatFileDataSource.this.totalBytes);
                ConcatFileDataSource.this.transcript.write(String.valueOf(ConcatFileDataSource.this.context) + " 1 " + ConcatFileDataSource.GAP_LABEL + ' ' + start + ' ' + end + " \n");
                ConcatFileDataSource.this.transcript.flush();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        private int getSilenceCount() {
            if (ConcatFileDataSource.this.addRandomSilence) {
                return this.silenceRandom.nextInt(ConcatFileDataSource.this.maxSilence) + 1;
            }
            return ConcatFileDataSource.this.maxSilence;
        }
    }
}

