/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.util.AudioFileProcessListener;
import edu.cmu.sphinx.frontend.util.ConcatAudioFileDataSource;
import edu.cmu.sphinx.frontend.util.DataUtil;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4ComponentList;
import edu.cmu.sphinx.util.props.S4Integer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioFileDataSource
extends BaseDataProcessor {
    @S4Integer(defaultValue=3200)
    public static final String PROP_BYTES_PER_READ = "bytesPerRead";
    @S4ComponentList(type=Configurable.class)
    public static final String AUDIO_FILE_LISTENERS = "audioFileListners";
    protected final List<AudioFileProcessListener> fileListeners = new ArrayList<AudioFileProcessListener>();
    protected InputStream dataStream;
    protected int sampleRate;
    protected int bytesPerRead;
    protected int bytesPerValue;
    private long totalValuesRead;
    protected boolean bigEndian;
    protected boolean signedData;
    private boolean streamEndReached;
    private boolean utteranceEndSent;
    private boolean utteranceStarted;
    private File curAudioFile;

    public AudioFileDataSource(int bytesPerRead, List<AudioFileProcessListener> listeners) {
        this.initLogger();
        this.create(bytesPerRead, listeners);
    }

    public AudioFileDataSource() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.logger = ps.getLogger();
        this.create(ps.getInt(PROP_BYTES_PER_READ), ps.getComponentList(AUDIO_FILE_LISTENERS, AudioFileProcessListener.class));
    }

    private void create(int bytesPerRead, List<AudioFileProcessListener> listeners) {
        this.bytesPerRead = bytesPerRead;
        if (listeners != null) {
            for (AudioFileProcessListener configurable : listeners) {
                this.addNewFileListener(configurable);
            }
        }
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.streamEndReached = false;
        this.utteranceEndSent = false;
        this.utteranceStarted = false;
        if (this.bytesPerRead % 2 == 1) {
            ++this.bytesPerRead;
        }
    }

    public void setAudioFile(File audioFile, String streamName) {
        try {
            this.setAudioFile(audioFile.toURI().toURL(), streamName);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void setAudioFile(URL audioFileURL, String streamName) {
        if (this.dataStream != null) {
            try {
                this.dataStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.dataStream = null;
        }
        assert (audioFileURL != null);
        if (streamName != null) {
            streamName = audioFileURL.getPath();
        }
        AudioInputStream audioStream = null;
        try {
            audioStream = AudioSystem.getAudioInputStream(audioFileURL);
        }
        catch (UnsupportedAudioFileException e) {
            System.err.println("Audio file format not supported: " + e);
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.curAudioFile = new File(audioFileURL.getFile());
        for (AudioFileProcessListener fileListener : this.fileListeners) {
            fileListener.audioFileProcStarted(this.curAudioFile);
        }
        this.setInputStream(audioStream, streamName);
    }

    public void setInputStream(AudioInputStream inputStream, String streamName) {
        this.dataStream = inputStream;
        this.streamEndReached = false;
        this.utteranceEndSent = false;
        this.utteranceStarted = false;
        AudioFormat format = inputStream.getFormat();
        this.sampleRate = (int)format.getSampleRate();
        this.bigEndian = format.isBigEndian();
        String s = format.toString();
        this.logger.finer("input format is " + s);
        if (format.getSampleSizeInBits() % 8 != 0) {
            throw new Error("StreamDataSource: bits per sample must be a multiple of 8.");
        }
        this.bytesPerValue = format.getSampleSizeInBits() / 8;
        AudioFormat.Encoding encoding = format.getEncoding();
        if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            this.signedData = true;
        } else if (encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            this.signedData = false;
        } else {
            throw new RuntimeException("used file encoding is not supported");
        }
        this.totalValuesRead = 0L;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data output = null;
        if (this.streamEndReached) {
            if (!this.utteranceEndSent) {
                output = this.createDataEndSignal();
                this.utteranceEndSent = true;
            }
        } else if (!this.utteranceStarted) {
            this.utteranceStarted = true;
            output = new DataStartSignal(this.sampleRate);
        } else if (this.dataStream != null && (output = this.readNextFrame()) == null && !this.utteranceEndSent) {
            output = this.createDataEndSignal();
            this.utteranceEndSent = true;
        }
        return output;
    }

    private DataEndSignal createDataEndSignal() {
        if (!(this instanceof ConcatAudioFileDataSource)) {
            for (AudioFileProcessListener fileListener : this.fileListeners) {
                fileListener.audioFileProcFinished(this.curAudioFile);
            }
        }
        return new DataEndSignal(this.getDuration());
    }

    private Data readNextFrame() throws DataProcessingException {
        long firstSample;
        byte[] samplesBuffer;
        int bytesToRead;
        int totalRead;
        block5: {
            totalRead = 0;
            bytesToRead = this.bytesPerRead;
            samplesBuffer = new byte[this.bytesPerRead];
            firstSample = this.totalValuesRead;
            try {
                int read;
                do {
                    if ((read = this.dataStream.read(samplesBuffer, totalRead, bytesToRead - totalRead)) <= 0) continue;
                    totalRead += read;
                } while (read != -1 && totalRead < bytesToRead);
                if (totalRead > 0) break block5;
                this.closeDataStream();
                return null;
            }
            catch (IOException ioe) {
                throw new DataProcessingException("Error reading data", ioe);
            }
        }
        this.totalValuesRead += (long)(totalRead / this.bytesPerValue);
        if (totalRead < bytesToRead) {
            totalRead = totalRead % 2 == 0 ? totalRead + 2 : totalRead + 3;
            byte[] shrinkedBuffer = new byte[totalRead];
            System.arraycopy(samplesBuffer, 0, shrinkedBuffer, 0, totalRead);
            samplesBuffer = shrinkedBuffer;
            this.closeDataStream();
        }
        double[] doubleData = this.bigEndian ? DataUtil.bytesToValues(samplesBuffer, 0, totalRead, this.bytesPerValue, this.signedData) : DataUtil.littleEndianBytesToValues(samplesBuffer, 0, totalRead, this.bytesPerValue, this.signedData);
        return new DoubleData(doubleData, this.sampleRate, firstSample);
    }

    private void closeDataStream() throws IOException {
        this.streamEndReached = true;
        if (this.dataStream != null) {
            this.dataStream.close();
        }
    }

    private long getDuration() {
        return (long)((double)this.totalValuesRead / (double)this.sampleRate * 1000.0);
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public void addNewFileListener(AudioFileProcessListener l) {
        if (l == null) {
            return;
        }
        this.fileListeners.add(l);
    }

    public void removeNewFileListener(AudioFileProcessListener l) {
        if (l == null) {
            return;
        }
        this.fileListeners.remove(l);
    }
}

