/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.transform;

import edu.cmu.sphinx.frontend.transform.DiscreteCosineTransform;
import java.util.Arrays;

public class KaldiDiscreteCosineTransform
extends DiscreteCosineTransform {
    public KaldiDiscreteCosineTransform(int numberMelFilters, int cepstrumSize) {
        super(numberMelFilters, cepstrumSize);
    }

    public KaldiDiscreteCosineTransform() {
    }

    @Override
    protected void computeMelCosine() {
        this.melcosine = new double[this.cepstrumSize][this.numberMelFilters];
        Arrays.fill(this.melcosine[0], Math.sqrt(1.0 / (double)this.numberMelFilters));
        double normScale = Math.sqrt(2.0 / (double)this.numberMelFilters);
        int i = 1;
        while (i < this.cepstrumSize) {
            double frequency = Math.PI * (double)i / (double)this.numberMelFilters;
            int j = 0;
            while (j < this.numberMelFilters) {
                this.melcosine[i][j] = normScale * Math.cos(frequency * ((double)j + 0.5));
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected double[] applyMelCosine(double[] melspectrum) {
        double[] cepstrum = new double[this.cepstrumSize];
        int i = 0;
        while (i < cepstrum.length) {
            int j = 0;
            while (j < this.numberMelFilters) {
                int n = i;
                cepstrum[n] = cepstrum[n] + melspectrum[j] * this.melcosine[i][j];
                ++j;
            }
            ++i;
        }
        return cepstrum;
    }
}

