/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.transform;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.util.Complex;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Integer;

public class DiscreteFourierTransform
extends BaseDataProcessor {
    @S4Integer(defaultValue=-1)
    public static final String PROP_NUMBER_FFT_POINTS = "numberFftPoints";
    @S4Boolean(defaultValue=false)
    public static final String PROP_INVERT = "invert";
    private boolean isNumberFftPointsSet;
    private int numberFftPoints;
    private int logBase2NumberFftPoints;
    private int numberDataPoints;
    private boolean invert;
    private Complex[] weightFft;
    private Complex[] inputFrame;
    private Complex[] from;
    private Complex[] to;
    private Complex weightFftTimesFrom2;
    private Complex tempComplex;

    public DiscreteFourierTransform(int numberFftPoints, boolean invert) {
        this.initLogger();
        this.numberFftPoints = numberFftPoints;
        this.isNumberFftPointsSet = numberFftPoints != -1;
        this.invert = invert;
    }

    public DiscreteFourierTransform() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.logger = ps.getLogger();
        this.numberFftPoints = ps.getInt(PROP_NUMBER_FFT_POINTS);
        this.isNumberFftPointsSet = this.numberFftPoints != -1;
        this.invert = ps.getBoolean(PROP_INVERT);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.isNumberFftPointsSet) {
            this.initializeFFT();
        }
    }

    private void initializeFFT() {
        this.computeLogBase2(this.numberFftPoints);
        this.createWeightFft(this.numberFftPoints, this.invert);
        this.initComplexArrays();
        this.weightFftTimesFrom2 = new Complex();
        this.tempComplex = new Complex();
    }

    private void initComplexArrays() {
        this.inputFrame = new Complex[this.numberFftPoints];
        this.from = new Complex[this.numberFftPoints];
        this.to = new Complex[this.numberFftPoints];
        int i = 0;
        while (i < this.numberFftPoints) {
            this.inputFrame[i] = new Complex();
            this.from[i] = new Complex();
            this.to[i] = new Complex();
            ++i;
        }
    }

    private DoubleData process(DoubleData input) throws IllegalArgumentException {
        int i;
        double[] in = input.getValues();
        if (this.numberFftPoints < in.length) {
            i = 0;
            while (i < this.numberFftPoints) {
                this.inputFrame[i].set(in[i], 0.0);
                ++i;
            }
            while (i < in.length) {
                this.tempComplex.set(in[i], 0.0);
                this.inputFrame[i % this.numberFftPoints].addComplex(this.inputFrame[i % this.numberFftPoints], this.tempComplex);
                ++i;
            }
        } else {
            i = 0;
            while (i < in.length) {
                this.inputFrame[i].set(in[i], 0.0);
                ++i;
            }
            while (i < this.numberFftPoints) {
                this.inputFrame[i].reset();
                ++i;
            }
        }
        double[] outputSpectrum = new double[(this.numberFftPoints >> 1) + 1];
        this.recurseFft(this.inputFrame, outputSpectrum, this.numberFftPoints, this.invert);
        DoubleData output = new DoubleData(outputSpectrum, input.getSampleRate(), input.getFirstSampleNumber());
        return output;
    }

    private void computeLogBase2(int numberFftPoints) throws IllegalArgumentException {
        this.logBase2NumberFftPoints = 0;
        int k = numberFftPoints;
        while (k > 1) {
            if (k % 2 != 0 || numberFftPoints < 0) {
                throw new IllegalArgumentException("Not a power of 2: " + numberFftPoints);
            }
            k >>= 1;
            ++this.logBase2NumberFftPoints;
        }
    }

    private void createWeightFft(int numberFftPoints, boolean invert) {
        this.weightFft = new Complex[numberFftPoints >> 1];
        double w = Math.PI * -2 / (double)numberFftPoints;
        if (invert) {
            w = -w;
        }
        int k = 0;
        while (k < numberFftPoints >> 1) {
            this.weightFft[k] = new Complex(Math.cos(w * (double)k), Math.sin(w * (double)k));
            ++k;
        }
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data input = this.getPredecessor().getData();
        if (input != null && input instanceof DoubleData) {
            DoubleData data = (DoubleData)input;
            if (!this.isNumberFftPointsSet) {
                if (this.numberDataPoints != data.getValues().length) {
                    this.numberDataPoints = data.getValues().length;
                    this.numberFftPoints = DiscreteFourierTransform.getNumberFftPoints(this.numberDataPoints);
                    this.initializeFFT();
                }
            } else if (this.numberDataPoints != data.getValues().length) {
                this.numberDataPoints = data.getValues().length;
                int idealFftPoints = DiscreteFourierTransform.getNumberFftPoints(this.numberDataPoints);
                if (idealFftPoints != this.numberFftPoints) {
                    this.logger.warning("User set numberFftPoints (" + this.numberFftPoints + ") is not ideal (" + idealFftPoints + ')');
                }
            }
            input = this.process(data);
        }
        return input;
    }

    private static int getNumberFftPoints(int numberSamples) {
        int fftPoints = 1;
        while (fftPoints < numberSamples) {
            if ((fftPoints <<= 1) >= 1) continue;
            throw new Error("Invalid # of FFT points: " + fftPoints);
        }
        return fftPoints;
    }

    private void recurseFft(Complex[] input, double[] output, int numberFftPoints, boolean invert) {
        double divisor = !invert ? 1.0 : (double)numberFftPoints;
        int i = 0;
        while (i < numberFftPoints) {
            this.to[i].reset();
            this.from[i].scaleComplex(input[i], divisor);
            ++i;
        }
        this.butterflyStage(this.from, this.to, numberFftPoints, numberFftPoints >> 1);
        if ((this.logBase2NumberFftPoints & 1) == 0) {
            i = 0;
            while (i <= numberFftPoints >> 1) {
                output[i] = this.from[i].squaredMagnitudeComplex();
                ++i;
            }
        } else {
            i = 0;
            while (i <= numberFftPoints >> 1) {
                output[i] = this.to[i].squaredMagnitudeComplex();
                ++i;
            }
        }
    }

    private void butterflyStage(Complex[] from, Complex[] to, int numberFftPoints, int currentDistance) {
        if (currentDistance > 0) {
            int twiceCurrentDistance = 2 * currentDistance;
            int s = 0;
            while (s < currentDistance) {
                int ndx1From = s;
                int ndx2From = s + currentDistance;
                int ndx1To = s;
                int ndx2To = s + (numberFftPoints >> 1);
                int ndxWeightFft = 0;
                while (ndxWeightFft < numberFftPoints >> 1) {
                    this.weightFftTimesFrom2.multiplyComplex(this.weightFft[ndxWeightFft], from[ndx2From]);
                    to[ndx1To].addComplex(from[ndx1From], this.weightFftTimesFrom2);
                    to[ndx2To].subtractComplex(from[ndx1From], this.weightFftTimesFrom2);
                    ndx1From += twiceCurrentDistance;
                    ndx2From += twiceCurrentDistance;
                    ndx1To += currentDistance;
                    ndx2To += currentDistance;
                    ndxWeightFft += currentDistance;
                }
                ++s;
            }
            this.butterflyStage(to, from, numberFftPoints, currentDistance >> 1);
        }
    }
}

