/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.transform;

import edu.cmu.sphinx.frontend.transform.DiscreteCosineTransform;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;

public class DiscreteCosineTransform2
extends DiscreteCosineTransform {
    public DiscreteCosineTransform2(int numberMelFilters, int cepstrumSize) {
        super(numberMelFilters, cepstrumSize);
    }

    public DiscreteCosineTransform2() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
    }

    @Override
    protected double[] applyMelCosine(double[] melspectrum) {
        double[] cepstrum = new double[this.cepstrumSize];
        double sqrt_inv_n = Math.sqrt(1.0 / (double)this.numberMelFilters);
        double sqrt_inv_2n = Math.sqrt(2.0 / (double)this.numberMelFilters);
        cepstrum[0] = melspectrum[0];
        int j = 1;
        while (j < this.numberMelFilters) {
            cepstrum[0] = cepstrum[0] + melspectrum[j];
            ++j;
        }
        cepstrum[0] = cepstrum[0] * sqrt_inv_n;
        if (this.numberMelFilters <= 0) {
            return cepstrum;
        }
        int i = 1;
        while (i < cepstrum.length) {
            double[] melcosine_i = this.melcosine[i];
            int j2 = 0;
            cepstrum[i] = 0.0;
            j2 = 0;
            while (j2 < this.numberMelFilters) {
                int n = i;
                cepstrum[n] = cepstrum[n] + melspectrum[j2] * melcosine_i[j2];
                ++j2;
            }
            int n = i++;
            cepstrum[n] = cepstrum[n] * sqrt_inv_2n;
        }
        return cepstrum;
    }
}

