/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.transform;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;

public class DiscreteCosineTransform
extends BaseDataProcessor {
    @S4Integer(defaultValue=40)
    public static final String PROP_NUMBER_FILTERS = "numberFilters";
    @S4Integer(defaultValue=13)
    public static final String PROP_CEPSTRUM_LENGTH = "cepstrumLength";
    protected int cepstrumSize;
    protected int numberMelFilters;
    protected double[][] melcosine;
    static final double LOG_FLOOR = 1.0E-4;

    public DiscreteCosineTransform(int numberMelFilters, int cepstrumSize) {
        this.initLogger();
        this.numberMelFilters = numberMelFilters;
        this.cepstrumSize = cepstrumSize;
    }

    public DiscreteCosineTransform() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.numberMelFilters = ps.getInt(PROP_NUMBER_FILTERS);
        this.cepstrumSize = ps.getInt(PROP_CEPSTRUM_LENGTH);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data input = this.getPredecessor().getData();
        if (input != null && input instanceof DoubleData) {
            input = this.process((DoubleData)input);
        }
        return input;
    }

    private DoubleData process(DoubleData input) throws IllegalArgumentException {
        double[] melspectrum = input.getValues();
        if (this.melcosine == null) {
            this.numberMelFilters = melspectrum.length;
            this.computeMelCosine();
        } else if (melspectrum.length != this.numberMelFilters) {
            throw new IllegalArgumentException("MelSpectrum size is incorrect: melspectrum.length == " + melspectrum.length + ", numberMelFilters == " + this.numberMelFilters);
        }
        int i = 0;
        while (i < melspectrum.length) {
            melspectrum[i] = Math.log(melspectrum[i] + 1.0E-4);
            ++i;
        }
        double[] cepstrum = this.applyMelCosine(melspectrum);
        return new DoubleData(cepstrum, input.getSampleRate(), input.getFirstSampleNumber());
    }

    protected void computeMelCosine() {
        this.melcosine = new double[this.cepstrumSize][this.numberMelFilters];
        double period = 2.0 * (double)this.numberMelFilters;
        int i = 0;
        while (i < this.cepstrumSize) {
            double frequency = Math.PI * 2 * (double)i / period;
            int j = 0;
            while (j < this.numberMelFilters) {
                this.melcosine[i][j] = Math.cos(frequency * ((double)j + 0.5));
                ++j;
            }
            ++i;
        }
    }

    protected double[] applyMelCosine(double[] melspectrum) {
        double[] cepstrum = new double[this.cepstrumSize];
        double period = this.numberMelFilters;
        double beta = 0.5;
        int i = 0;
        while (i < cepstrum.length) {
            if (this.numberMelFilters > 0) {
                double[] melcosine_i = this.melcosine[i];
                int j = 0;
                int n = i;
                cepstrum[n] = cepstrum[n] + beta * melspectrum[j] * melcosine_i[j];
                j = 1;
                while (j < this.numberMelFilters) {
                    int n2 = i;
                    cepstrum[n2] = cepstrum[n2] + melspectrum[j] * melcosine_i[j];
                    ++j;
                }
                int n3 = i;
                cepstrum[n3] = cepstrum[n3] / period;
            }
            ++i;
        }
        return cepstrum;
    }
}

