/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.frequencywarp;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.frequencywarp.FrequencyWarper;
import edu.cmu.sphinx.frontend.frequencywarp.PLPFilter;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;

public class PLPFrequencyFilterBank
extends BaseDataProcessor {
    @S4Integer(defaultValue=32)
    public static final String PROP_NUMBER_FILTERS = "numberFilters";
    @S4Double(defaultValue=130.0)
    public static final String PROP_MIN_FREQ = "minimumFrequency";
    @S4Double(defaultValue=3600.0)
    public static final String PROP_MAX_FREQ = "maximumFrequency";
    private int sampleRate;
    private int numberFftPoints;
    private int numberFilters;
    private double minFreq;
    private double maxFreq;
    private PLPFilter[] criticalBandFilter;
    private double[] equalLoudnessScaling;

    public PLPFrequencyFilterBank(double minFreq, double maxFreq, int numberFilters) {
        this.initLogger();
        this.minFreq = minFreq;
        this.maxFreq = maxFreq;
        this.numberFilters = numberFilters;
    }

    public PLPFrequencyFilterBank() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.minFreq = ps.getDouble(PROP_MIN_FREQ);
        this.maxFreq = ps.getDouble(PROP_MAX_FREQ);
        this.numberFilters = ps.getInt(PROP_NUMBER_FILTERS);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    private void buildCriticalBandFilterbank() throws IllegalArgumentException {
        int numberDFTPoints = (this.numberFftPoints >> 1) + 1;
        FrequencyWarper bark = new FrequencyWarper();
        this.criticalBandFilter = new PLPFilter[this.numberFilters];
        if (this.numberFftPoints == 0) {
            throw new IllegalArgumentException("Number of FFT points is zero");
        }
        if (this.numberFilters < 1) {
            throw new IllegalArgumentException("Number of filters illegal: " + this.numberFilters);
        }
        double[] DFTFrequencies = new double[numberDFTPoints];
        double nyquistFreq = this.sampleRate / 2;
        int i = 0;
        while (i < numberDFTPoints) {
            DFTFrequencies[i] = (double)i * nyquistFreq / (double)(numberDFTPoints - 1);
            ++i;
        }
        double minBarkFreq = bark.hertzToBark(this.minFreq);
        double maxBarkFreq = bark.hertzToBark(this.maxFreq);
        if (this.numberFilters < 1) {
            throw new IllegalArgumentException("Number of filters illegal: " + this.numberFilters);
        }
        double deltaBarkFreq = (maxBarkFreq - minBarkFreq) / (double)(this.numberFilters + 1);
        i = 0;
        while (i < this.numberFilters) {
            double centerFreq = bark.barkToHertz(minBarkFreq + (double)i * deltaBarkFreq);
            this.criticalBandFilter[i] = new PLPFilter(DFTFrequencies, centerFreq);
            ++i;
        }
    }

    private double loudnessScalingFunction(double freq) {
        double fsq = freq * freq;
        double fsub = fsq / (fsq + 160000.0);
        return fsub * fsub * ((fsq + 1440000.0) / (fsq + 9610000.0));
    }

    private void buildEqualLoudnessScalingFactors() {
        this.equalLoudnessScaling = new double[this.numberFilters];
        int i = 0;
        while (i < this.numberFilters) {
            double centerFreq = this.criticalBandFilter[i].centerFreqInHz;
            this.equalLoudnessScaling[i] = this.loudnessScalingFunction(centerFreq);
            ++i;
        }
    }

    private DoubleData process(DoubleData input) throws IllegalArgumentException {
        double[] in = input.getValues();
        if (this.criticalBandFilter == null || this.sampleRate != input.getSampleRate()) {
            this.numberFftPoints = in.length - 1 << 1;
            this.sampleRate = input.getSampleRate();
            this.buildCriticalBandFilterbank();
            this.buildEqualLoudnessScalingFactors();
        } else if (in.length != (this.numberFftPoints >> 1) + 1) {
            throw new IllegalArgumentException("Window size is incorrect: in.length == " + in.length + ", numberFftPoints == " + ((this.numberFftPoints >> 1) + 1));
        }
        double[] outputPLPSpectralArray = new double[this.numberFilters];
        int i = 0;
        while (i < this.numberFilters) {
            outputPLPSpectralArray[i] = this.criticalBandFilter[i].filterOutput(in);
            int n = i;
            outputPLPSpectralArray[n] = outputPLPSpectralArray[n] * this.equalLoudnessScaling[i];
            ++i;
        }
        DoubleData output = new DoubleData(outputPLPSpectralArray, input.getSampleRate(), input.getFirstSampleNumber());
        return output;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data input = this.getPredecessor().getData();
        if (input != null && input instanceof DoubleData) {
            input = this.process((DoubleData)input);
        }
        return input;
    }
}

