/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.frequencywarp;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.frequencywarp.LinearPredictor;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;

public class PLPCepstrumProducer
extends BaseDataProcessor {
    @S4Integer(defaultValue=32)
    public static final String PROP_NUMBER_FILTERS = "numberFilters";
    @S4Integer(defaultValue=13)
    public static final String PROP_CEPSTRUM_LENGTH = "cepstrumLength";
    @S4Integer(defaultValue=14)
    public static final String PROP_LPC_ORDER = "lpcOrder";
    private int cepstrumSize;
    private int LPCOrder;
    private int numberPLPFilters;
    private double[][] cosine;

    public PLPCepstrumProducer(int numberPLPFilters, int cepstrumSize, int LPCOrder) {
        this.initLogger();
        this.numberPLPFilters = numberPLPFilters;
        this.cepstrumSize = cepstrumSize;
        this.LPCOrder = LPCOrder;
    }

    public PLPCepstrumProducer() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.numberPLPFilters = ps.getInt(PROP_NUMBER_FILTERS);
        this.cepstrumSize = ps.getInt(PROP_CEPSTRUM_LENGTH);
        this.LPCOrder = ps.getInt(PROP_LPC_ORDER);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.computeCosine();
    }

    private void computeCosine() {
        this.cosine = new double[this.LPCOrder + 1][this.numberPLPFilters];
        double period = 2.0 * (double)this.numberPLPFilters;
        int i = 0;
        while (i <= this.LPCOrder) {
            double frequency = Math.PI * 2 * (double)i / period;
            int j = 0;
            while (j < this.numberPLPFilters) {
                this.cosine[i][j] = Math.cos(frequency * ((double)j + 0.5));
                ++j;
            }
            ++i;
        }
    }

    private double[] powerLawCompress(double[] inspectrum) {
        double[] compressedspectrum = new double[inspectrum.length];
        int i = 0;
        while (i < inspectrum.length) {
            compressedspectrum[i] = Math.pow(inspectrum[i], 0.3333333333333333);
            ++i;
        }
        return compressedspectrum;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data input;
        Data output = input = this.getPredecessor().getData();
        if (input != null && input instanceof DoubleData) {
            output = this.process((DoubleData)input);
        }
        return output;
    }

    private Data process(DoubleData input) throws IllegalArgumentException {
        double[] plpspectrum = input.getValues();
        if (plpspectrum.length != this.numberPLPFilters) {
            throw new IllegalArgumentException("PLPSpectrum size is incorrect: plpspectrum.length == " + plpspectrum.length + ", numberPLPFilters == " + this.numberPLPFilters);
        }
        double[] compressedspectrum = this.powerLawCompress(plpspectrum);
        double[] autocor = this.applyCosine(compressedspectrum);
        LinearPredictor LPC = new LinearPredictor(this.LPCOrder);
        LPC.getARFilter(autocor);
        double[] cepstrumDouble = LPC.getData(this.cepstrumSize);
        DoubleData cepstrum = new DoubleData(cepstrumDouble, input.getSampleRate(), input.getFirstSampleNumber());
        return cepstrum;
    }

    private double[] applyCosine(double[] plpspectrum) {
        double[] autocor = new double[this.LPCOrder + 1];
        double period = this.numberPLPFilters;
        double beta = 0.5;
        int i = 0;
        while (i <= this.LPCOrder) {
            if (this.numberPLPFilters > 0) {
                double[] cosine_i = this.cosine[i];
                int j = 0;
                int n = i;
                autocor[n] = autocor[n] + beta * plpspectrum[j] * cosine_i[j];
                j = 1;
                while (j < this.numberPLPFilters) {
                    int n2 = i;
                    autocor[n2] = autocor[n2] + plpspectrum[j] * cosine_i[j];
                    ++j;
                }
                int n3 = i;
                autocor[n3] = autocor[n3] / period;
            }
            ++i;
        }
        return autocor;
    }
}

