/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.frequencywarp;

public class MelFilter {
    private double[] weight;
    private int initialFreqIndex;

    public MelFilter(double leftEdge, double centerFreq, double rightEdge, double initialFreq, double deltaFreq) throws IllegalArgumentException {
        if (deltaFreq == 0.0) {
            throw new IllegalArgumentException("deltaFreq has zero value");
        }
        if (Math.round(rightEdge - leftEdge) == 0L || Math.round(centerFreq - leftEdge) == 0L || Math.round(rightEdge - centerFreq) == 0L) {
            throw new IllegalArgumentException("Filter boundaries too close");
        }
        int numberElementsWeightField = (int)Math.round((rightEdge - leftEdge) / deltaFreq + 1.0);
        if (numberElementsWeightField == 0) {
            throw new IllegalArgumentException("Number of elements in mel is zero.");
        }
        this.weight = new double[numberElementsWeightField];
        double filterHeight = 2.0 / (rightEdge - leftEdge);
        double leftSlope = filterHeight / (centerFreq - leftEdge);
        double rightSlope = filterHeight / (centerFreq - rightEdge);
        double currentFreq = initialFreq;
        int indexFilterWeight = 0;
        while (currentFreq <= rightEdge) {
            this.weight[indexFilterWeight] = currentFreq < centerFreq ? leftSlope * (currentFreq - leftEdge) : filterHeight + rightSlope * (currentFreq - centerFreq);
            currentFreq += deltaFreq;
            ++indexFilterWeight;
        }
        this.initialFreqIndex = (int)Math.round(initialFreq / deltaFreq);
    }

    public double filterOutput(double[] spectrum) {
        double output = 0.0;
        int i = 0;
        while (i < this.weight.length) {
            int indexSpectrum = this.initialFreqIndex + i;
            if (indexSpectrum < spectrum.length) {
                output += spectrum[indexSpectrum] * this.weight[i];
            }
            ++i;
        }
        return output;
    }
}

