/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.frequencywarp;

import java.util.Arrays;

public class LinearPredictor {
    private int order;
    private int cepstrumOrder;
    private double[] reflectionCoeffs;
    private double[] ARParameters;
    private double alpha;
    private double[] cepstra;
    private final double[] bilinearCepstra;

    public LinearPredictor(int order) {
        this.order = order;
        this.reflectionCoeffs = null;
        this.ARParameters = null;
        this.alpha = 0.0;
        this.cepstra = null;
        this.bilinearCepstra = null;
    }

    public double[] getARFilter(double[] autocor) {
        if (autocor[0] == 0.0) {
            return null;
        }
        this.reflectionCoeffs = new double[this.order + 1];
        this.ARParameters = new double[this.order + 1];
        double[] backwardPredictor = new double[this.order + 1];
        this.alpha = autocor[0];
        this.reflectionCoeffs[1] = -autocor[1] / autocor[0];
        this.ARParameters[0] = 1.0;
        this.ARParameters[1] = this.reflectionCoeffs[1];
        this.alpha *= 1.0 - this.reflectionCoeffs[1] * this.reflectionCoeffs[1];
        int i = 2;
        while (i <= this.order) {
            int j = 1;
            while (j < i) {
                backwardPredictor[j] = this.ARParameters[i - j];
                ++j;
            }
            this.reflectionCoeffs[i] = 0.0;
            j = 0;
            while (j < i) {
                int n = i;
                this.reflectionCoeffs[n] = this.reflectionCoeffs[n] - this.ARParameters[j] * autocor[i - j];
                ++j;
            }
            int n = i;
            this.reflectionCoeffs[n] = this.reflectionCoeffs[n] / this.alpha;
            j = 1;
            while (j < i) {
                int n2 = j;
                this.ARParameters[n2] = this.ARParameters[n2] + this.reflectionCoeffs[i] * backwardPredictor[j];
                ++j;
            }
            this.ARParameters[i] = this.reflectionCoeffs[i];
            this.alpha *= 1.0 - this.reflectionCoeffs[i] * this.reflectionCoeffs[i];
            if (this.alpha <= 0.0) {
                return null;
            }
            ++i;
        }
        return this.ARParameters;
    }

    public double[] reflectionCoeffsToARParameters(double[] RC, int lpcorder) {
        double[][] tmp = new double[lpcorder + 1][lpcorder + 1];
        this.order = lpcorder;
        this.reflectionCoeffs = (double[])RC.clone();
        int i = 1;
        while (i <= lpcorder) {
            int m = 1;
            while (m < i) {
                tmp[i][m] = tmp[i - 1][m] - RC[i] * tmp[i - 1][i - m];
                ++m;
            }
            tmp[i][i] = RC[i];
            ++i;
        }
        this.ARParameters[0] = 1.0;
        int m = 1;
        while (m <= lpcorder) {
            this.ARParameters[m] = tmp[m][m];
            ++m;
        }
        return this.ARParameters;
    }

    public double[] getData(int ceporder) {
        int j;
        double sum;
        if (ceporder <= 0) {
            return null;
        }
        this.cepstrumOrder = ceporder;
        this.cepstra = new double[this.cepstrumOrder];
        this.cepstra[0] = Math.log(this.alpha);
        if (this.cepstrumOrder == 1) {
            return this.cepstra;
        }
        this.cepstra[1] = -this.ARParameters[1];
        int i = 2;
        while (i < Math.min(this.cepstrumOrder, this.order + 1)) {
            sum = (double)i * this.ARParameters[i];
            j = 1;
            while (j < i) {
                sum += this.ARParameters[j] * this.cepstra[i - j] * (double)(i - j);
                ++j;
            }
            this.cepstra[i] = -sum / (double)i;
            ++i;
        }
        while (i < this.cepstrumOrder) {
            sum = 0.0;
            j = 1;
            while (j <= this.order) {
                sum += this.ARParameters[j] * this.cepstra[i - j] * (double)(i - j);
                ++j;
            }
            this.cepstra[i] = -sum / (double)i;
            ++i;
        }
        return this.cepstra;
    }

    public double[] getBilinearCepstra(double warp, int nbilincepstra) {
        double[][] g = new double[nbilincepstra][this.cepstrumOrder];
        double[] lincep = Arrays.copyOf(this.cepstra, this.cepstrumOrder);
        this.bilinearCepstra[0] = lincep[0];
        lincep[0] = 0.0;
        g[0][this.cepstrumOrder - 1] = lincep[this.cepstrumOrder - 1];
        int i = 1;
        while (i < nbilincepstra) {
            g[i][this.cepstrumOrder - 1] = 0.0;
            ++i;
        }
        i = this.cepstrumOrder - 2;
        while (i >= 0) {
            g[0][i] = warp * g[0][i + 1] + lincep[i];
            g[1][i] = (1.0 - warp * warp) * g[0][i + 1] + warp * g[1][i + 1];
            int j = 2;
            while (j < nbilincepstra) {
                g[j][i] = warp * (g[j][i + 1] - g[j - 1][i]) + g[j - 1][i + 1];
                ++j;
            }
            --i;
        }
        i = 1;
        while (i <= nbilincepstra) {
            this.bilinearCepstra[i] = g[i][0];
            ++i;
        }
        return this.bilinearCepstra;
    }
}

