/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.filter;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;

public class EnergyFilter
extends BaseDataProcessor {
    @S4Double(defaultValue=2.0)
    public static final String PROP_MAX_ENERGY = "maxEnergy";
    private double maxEnergy;

    public EnergyFilter(double maxEnergy) {
        this.initLogger();
        this.maxEnergy = maxEnergy;
        this.initialize();
    }

    public EnergyFilter() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.maxEnergy = ps.getDouble(PROP_MAX_ENERGY);
    }

    @Override
    public Data getData() throws DataProcessingException {
        float energy = 0.0f;
        Data input = null;
        do {
            if ((input = this.getPredecessor().getData()) == null || !(input instanceof DoubleData)) {
                return input;
            }
            energy = 0.0f;
            double[] dArray = ((DoubleData)input).getValues();
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                double d = dArray[n2];
                energy = (float)((double)energy + d * d);
                ++n2;
            }
        } while ((double)energy < this.maxEnergy);
        return input;
    }
}

