/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.feature;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class LiveCMN
extends BaseDataProcessor {
    private DecimalFormat formatter = new DecimalFormat("0.00;-0.00", new DecimalFormatSymbols(Locale.US));
    @S4Integer(defaultValue=200)
    public static final String PROP_INITIAL_CMN_WINDOW = "initialCmnWindow";
    private int initialCmnWindow;
    @S4Integer(defaultValue=300)
    public static final String PROP_CMN_WINDOW = "cmnWindow";
    private int cmnWindow;
    @S4Integer(defaultValue=400)
    public static final String PROP_CMN_SHIFT_WINDOW = "shiftWindow";
    private int cmnShiftWindow;
    private double[] currentMean;
    private double[] sum;
    private int numberFrame;
    List<Data> initialList = new LinkedList<Data>();

    public LiveCMN(double initialMean, int cmnWindow, int cmnShiftWindow, int initialCmnWindow) {
        this.initLogger();
        this.cmnWindow = cmnWindow;
        this.cmnShiftWindow = cmnShiftWindow;
        this.initialCmnWindow = initialCmnWindow;
    }

    public LiveCMN() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.cmnWindow = ps.getInt(PROP_CMN_WINDOW);
        this.cmnShiftWindow = ps.getInt(PROP_CMN_SHIFT_WINDOW);
        this.initialCmnWindow = ps.getInt(PROP_INITIAL_CMN_WINDOW);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    private void initMeansSums() {
        int size = -1;
        for (Data data : this.initialList) {
            if (!(data instanceof DoubleData)) continue;
            double[] cepstrum = ((DoubleData)data).getValues();
            if (size < 0) {
                size = cepstrum.length;
                this.sum = new double[size];
                this.numberFrame = 0;
            }
            if (!(cepstrum[0] >= 0.0)) continue;
            int j = 0;
            while (j < size) {
                int n = j;
                this.sum[n] = this.sum[n] + cepstrum[j];
                ++j;
            }
            ++this.numberFrame;
        }
        if (size < 0) {
            return;
        }
        this.currentMean = new double[size];
        int j = 0;
        while (j < size) {
            this.currentMean[j] = this.sum[j] / (double)this.numberFrame;
            ++j;
        }
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data output;
        if (this.sum == null) {
            while (this.initialList.size() < this.initialCmnWindow) {
                Data input = this.getPredecessor().getData();
                this.initialList.add(input);
                if (input instanceof SpeechEndSignal || input instanceof DataEndSignal) break;
            }
            this.initMeansSums();
            output = this.initialList.remove(0);
        } else {
            output = !this.initialList.isEmpty() ? this.initialList.remove(0) : this.getPredecessor().getData();
        }
        this.normalize(output);
        return output;
    }

    private void normalize(Data data) {
        int j;
        if (!(data instanceof DoubleData)) {
            return;
        }
        double[] cepstrum = ((DoubleData)data).getValues();
        if (cepstrum.length != this.sum.length) {
            throw new Error("Data length (" + cepstrum.length + ") not equal sum array length (" + this.sum.length + ')');
        }
        if (cepstrum[0] >= 0.0) {
            j = 0;
            while (j < cepstrum.length) {
                int n = j;
                this.sum[n] = this.sum[n] + cepstrum[j];
                ++j;
            }
            ++this.numberFrame;
        }
        j = 0;
        while (j < cepstrum.length) {
            int n = j;
            cepstrum[n] = cepstrum[n] - this.currentMean[j];
            ++j;
        }
        if (this.numberFrame > this.cmnShiftWindow) {
            StringBuilder cmn = new StringBuilder();
            int i = 0;
            while (i < this.currentMean.length) {
                cmn.append(this.formatter.format(this.currentMean[i]));
                cmn.append(' ');
                ++i;
            }
            this.logger.info(cmn.toString());
            this.updateMeanSumBuffers();
        }
    }

    private void updateMeanSumBuffers() {
        double sf = 1.0 / (double)this.numberFrame;
        System.arraycopy(this.sum, 0, this.currentMean, 0, this.sum.length);
        LiveCMN.multiplyArray(this.currentMean, sf);
        if (this.numberFrame >= this.cmnShiftWindow) {
            LiveCMN.multiplyArray(this.sum, sf * (double)this.cmnWindow);
            this.numberFrame = this.cmnWindow;
        }
    }

    private static void multiplyArray(double[] array, double multiplier) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] * multiplier;
        }
    }
}

