/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.feature;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.frontend.Signal;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Integer;

public class FrameDropper
extends BaseDataProcessor {
    @S4Integer(defaultValue=-1)
    public static final String PROP_DROP_EVERY_NTH_FRAME = "dropEveryNthFrame";
    @S4Boolean(defaultValue=false)
    public static final String PROP_REPLACE_NTH_WITH_PREVIOUS = "replaceNthWithPrevious";
    private Data lastFeature;
    private boolean replaceNthWithPrevious;
    private int dropEveryNthFrame;
    private int id;

    public FrameDropper(int dropEveryNthFrame, boolean replaceNthWithPrevious) {
        this.initLogger();
        this.initVars(dropEveryNthFrame, replaceNthWithPrevious);
    }

    public FrameDropper() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.initVars(ps.getInt(PROP_DROP_EVERY_NTH_FRAME), ps.getBoolean(PROP_REPLACE_NTH_WITH_PREVIOUS));
    }

    protected void initVars(int dropEveryNthFrame, boolean replaceNthWithPrevious) {
        this.dropEveryNthFrame = dropEveryNthFrame;
        if (dropEveryNthFrame <= 1) {
            throw new IllegalArgumentException("dropEveryNthFramemust be greater than one");
        }
        this.replaceNthWithPrevious = replaceNthWithPrevious;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.id = -1;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data feature = this.readData();
        if (feature != null) {
            if (!(feature instanceof Signal) && this.id % this.dropEveryNthFrame == this.dropEveryNthFrame - 1) {
                if (this.replaceNthWithPrevious) {
                    if (feature instanceof FloatData) {
                        FloatData floatLastFeature = (FloatData)this.lastFeature;
                        feature = new FloatData(floatLastFeature.getValues(), floatLastFeature.getSampleRate(), floatLastFeature.getFirstSampleNumber());
                    } else {
                        DoubleData doubleLastFeature = (DoubleData)this.lastFeature;
                        feature = new DoubleData(doubleLastFeature.getValues(), doubleLastFeature.getSampleRate(), doubleLastFeature.getFirstSampleNumber());
                    }
                } else {
                    feature = this.readData();
                }
            }
            if (feature != null) {
                if (feature instanceof DataEndSignal) {
                    this.id = -1;
                }
                this.lastFeature = feature instanceof FloatData ? feature : null;
            } else {
                this.lastFeature = null;
            }
        }
        return feature;
    }

    private Data readData() throws DataProcessingException {
        Data frame = this.getPredecessor().getData();
        if (frame != null) {
            ++this.id;
        }
        return frame;
    }
}

