/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.feature;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.frontend.feature.AbstractFeatureExtractor;

public class ConcatFeatureExtractor
extends AbstractFeatureExtractor {
    public ConcatFeatureExtractor(int window) {
        super(window);
    }

    public ConcatFeatureExtractor() {
    }

    @Override
    protected Data computeNextFeature() {
        DoubleData currentCepstrum = this.cepstraBuffer[this.currentPosition];
        float[] feature = new float[(this.window * 2 + 1) * currentCepstrum.getValues().length];
        int j = 0;
        int k = -this.window;
        while (k <= this.window) {
            double[] buffer;
            int position = (this.currentPosition + k + this.cepstraBufferSize) % this.cepstraBufferSize;
            double[] dArray = buffer = this.cepstraBuffer[position].getValues();
            int n = buffer.length;
            int n2 = 0;
            while (n2 < n) {
                double val = dArray[n2];
                feature[j++] = (float)val;
                ++n2;
            }
            ++k;
        }
        this.currentPosition = (this.currentPosition + 1) % this.cepstraBufferSize;
        return new FloatData(feature, currentCepstrum.getSampleRate(), currentCepstrum.getFirstSampleNumber());
    }
}

