/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.feature;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.util.LinkedList;
import java.util.List;

public class BatchVarNorm
extends BaseDataProcessor {
    private double[] variances;
    private List<Data> cepstraList;
    private int numberDataCepstra;

    public BatchVarNorm() {
        this.initLogger();
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.variances = null;
        this.cepstraList = new LinkedList<Data>();
    }

    private void reset() {
        this.variances = null;
        this.cepstraList.clear();
        this.numberDataCepstra = 0;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data output = null;
        if (!this.cepstraList.isEmpty()) {
            output = this.cepstraList.remove(0);
        } else {
            this.reset();
            if (this.readUtterance() > 0) {
                this.normalizeList();
                output = this.cepstraList.remove(0);
            }
        }
        return output;
    }

    private int readUtterance() throws DataProcessingException {
        Data input = null;
        do {
            if ((input = this.getPredecessor().getData()) == null) continue;
            if (input instanceof DoubleData) {
                ++this.numberDataCepstra;
                double[] cepstrumData = ((DoubleData)input).getValues();
                if (this.variances == null) {
                    this.variances = new double[cepstrumData.length];
                } else if (this.variances.length != cepstrumData.length) {
                    throw new Error("Inconsistent cepstrum lengths: sums: " + this.variances.length + ", cepstrum: " + cepstrumData.length);
                }
                int j = 0;
                while (j < cepstrumData.length) {
                    int n = j;
                    this.variances[n] = this.variances[n] + cepstrumData[j] * cepstrumData[j];
                    ++j;
                }
                this.cepstraList.add(input);
                continue;
            }
            if (input instanceof DataEndSignal || input instanceof SpeechEndSignal) {
                this.cepstraList.add(input);
                break;
            }
            this.cepstraList.add(input);
        } while (input != null);
        return this.numberDataCepstra;
    }

    private void normalizeList() {
        int i = 0;
        while (i < this.variances.length) {
            this.variances[i] = Math.sqrt((double)this.numberDataCepstra / this.variances[i]);
            ++i;
        }
        for (Data data : this.cepstraList) {
            if (!(data instanceof DoubleData)) continue;
            double[] cepstrum = ((DoubleData)data).getValues();
            int j = 0;
            while (j < cepstrum.length) {
                int n = j;
                cepstrum[n] = cepstrum[n] * this.variances[j];
                ++j;
            }
        }
    }
}

