/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.feature;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class BatchCMN
extends BaseDataProcessor {
    private double[] sums;
    private List<Data> cepstraList;
    private int numberDataCepstra;
    private DecimalFormat formatter = new DecimalFormat("0.00;-0.00", new DecimalFormatSymbols(Locale.US));

    public BatchCMN() {
        this.initLogger();
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.sums = null;
        this.cepstraList = new LinkedList<Data>();
    }

    private void reset() {
        this.sums = null;
        this.cepstraList.clear();
        this.numberDataCepstra = 0;
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data output = null;
        if (!this.cepstraList.isEmpty()) {
            output = this.cepstraList.remove(0);
        } else {
            this.reset();
            if (this.readUtterance() > 0) {
                this.normalizeList();
                output = this.cepstraList.remove(0);
            }
        }
        return output;
    }

    private int readUtterance() throws DataProcessingException {
        Data input = null;
        do {
            if ((input = this.getPredecessor().getData()) == null) continue;
            if (input instanceof DoubleData) {
                double[] cepstrumData = ((DoubleData)input).getValues();
                if (this.sums == null) {
                    this.sums = new double[cepstrumData.length];
                } else if (this.sums.length != cepstrumData.length) {
                    throw new Error("Inconsistent cepstrum lengths: sums: " + this.sums.length + ", cepstrum: " + cepstrumData.length);
                }
                if (cepstrumData[0] >= 0.0) {
                    int j = 0;
                    while (j < cepstrumData.length) {
                        int n = j;
                        this.sums[n] = this.sums[n] + cepstrumData[j];
                        ++j;
                    }
                    ++this.numberDataCepstra;
                }
                this.cepstraList.add(input);
                continue;
            }
            if (input instanceof DataEndSignal || input instanceof SpeechEndSignal) {
                this.cepstraList.add(input);
                break;
            }
            this.cepstraList.add(input);
        } while (input != null);
        return this.numberDataCepstra;
    }

    private void normalizeList() {
        StringBuilder cmn = new StringBuilder();
        int i = 0;
        while (i < this.sums.length) {
            int n = i;
            this.sums[n] = this.sums[n] / (double)this.numberDataCepstra;
            cmn.append(this.formatter.format(this.sums[i]));
            cmn.append(' ');
            ++i;
        }
        this.logger.info(cmn.toString());
        for (Data data : this.cepstraList) {
            if (!(data instanceof DoubleData)) continue;
            double[] cepstrum = ((DoubleData)data).getValues();
            int j = 0;
            while (j < cepstrum.length) {
                int n = j;
                cepstrum[n] = cepstrum[n] - this.sums[j];
                ++j;
            }
        }
    }
}

