/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.endpoint;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.endpoint.AbstractVoiceActivityDetector;
import edu.cmu.sphinx.frontend.endpoint.SpeechClassifiedData;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.logging.Level;

public class SpeechClassifier
extends AbstractVoiceActivityDetector {
    @S4Integer(defaultValue=10)
    public static final String PROP_FRAME_LENGTH_MS = "frameLengthInMs";
    @S4Double(defaultValue=0.0)
    public static final String PROP_MIN_SIGNAL = "minSignal";
    @S4Double(defaultValue=10.0)
    public static final String PROP_THRESHOLD = "threshold";
    @S4Double(defaultValue=0.003)
    public static final String PROP_ADJUSTMENT = "adjustment";
    protected final double averageNumber = 1.0;
    protected double adjustment;
    protected double level;
    protected double background;
    protected double minSignal;
    protected double threshold;
    protected float frameLengthSec;
    protected boolean isSpeech;
    protected long speechFrames;
    protected long backgroundFrames;
    protected double totalBackgroundLevel;
    protected double totalSpeechLevel;

    public SpeechClassifier(int frameLengthMs, double adjustment, double threshold, double minSignal) {
        this.initLogger();
        this.frameLengthSec = (float)frameLengthMs / 1000.0f;
        this.adjustment = adjustment;
        this.threshold = threshold;
        this.minSignal = minSignal;
        this.initialize();
    }

    public SpeechClassifier() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        int frameLengthMs = ps.getInt(PROP_FRAME_LENGTH_MS);
        this.frameLengthSec = (float)frameLengthMs / 1000.0f;
        this.adjustment = ps.getDouble(PROP_ADJUSTMENT);
        this.threshold = ps.getDouble(PROP_THRESHOLD);
        this.minSignal = ps.getDouble(PROP_MIN_SIGNAL);
        this.logger = ps.getLogger();
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.reset();
    }

    protected void reset() {
        this.level = 0.0;
        this.background = 300.0;
        this.resetStats();
    }

    public static double logRootMeanSquare(double[] samples) {
        assert (samples.length > 0);
        double sumOfSquares = 0.0;
        double[] dArray = samples;
        int n = samples.length;
        int n2 = 0;
        while (n2 < n) {
            double sample = dArray[n2];
            sumOfSquares += sample * sample;
            ++n2;
        }
        double rootMeanSquare = Math.sqrt(sumOfSquares / (double)samples.length);
        rootMeanSquare = Math.max(rootMeanSquare, 1.0);
        return LogMath.log10((float)rootMeanSquare) * 20.0f;
    }

    protected SpeechClassifiedData classify(DoubleData audio) {
        double current = SpeechClassifier.logRootMeanSquare(audio.getValues());
        this.isSpeech = false;
        if (current >= this.minSignal) {
            this.level = (this.level * 1.0 + current) / 2.0;
            this.background = current < this.background ? current : (this.background += (current - this.background) * this.adjustment);
            if (this.level < this.background) {
                this.level = this.background;
            }
            this.isSpeech = this.level - this.background > this.threshold;
        }
        SpeechClassifiedData labeledAudio = new SpeechClassifiedData(audio, this.isSpeech);
        if (this.logger.isLoggable(Level.FINEST)) {
            String speech = "";
            if (labeledAudio.isSpeech()) {
                speech = "*";
            }
            this.logger.finest("Bkg: " + this.background + ", level: " + this.level + ", current: " + current + ' ' + speech);
        }
        this.collectStats(this.isSpeech);
        return labeledAudio;
    }

    private void resetStats() {
        this.backgroundFrames = 1L;
        this.speechFrames = 1L;
        this.totalSpeechLevel = 0.0;
        this.totalBackgroundLevel = 0.0;
    }

    private void collectStats(boolean isSpeech) {
        if (isSpeech) {
            this.totalSpeechLevel += this.level;
            ++this.speechFrames;
        } else {
            this.totalBackgroundLevel += this.background;
            ++this.backgroundFrames;
        }
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data audio = this.getPredecessor().getData();
        if (audio instanceof DataStartSignal) {
            this.reset();
        }
        if (audio instanceof DoubleData) {
            DoubleData data = (DoubleData)audio;
            audio = this.classify(data);
        }
        return audio;
    }

    @Override
    public boolean isSpeech() {
        return this.isSpeech;
    }

    public double getSNR() {
        double snr = this.totalSpeechLevel / (double)this.speechFrames - this.totalBackgroundLevel / (double)this.backgroundFrames;
        this.logger.fine("Background " + this.totalBackgroundLevel / (double)this.backgroundFrames);
        this.logger.fine("Speech " + this.totalSpeechLevel / (double)this.speechFrames);
        this.logger.fine("SNR is " + snr);
        return snr;
    }

    public boolean getNoisy() {
        return this.getSNR() < 20.0;
    }
}

