/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.denoise;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.Arrays;

public class Denoise
extends BaseDataProcessor {
    double[] power;
    double[] noise;
    double[] floor;
    double[] peak;
    @S4Double(defaultValue=0.7)
    public static final String LAMBDA_POWER = "lambdaPower";
    double lambdaPower;
    @S4Double(defaultValue=0.995)
    public static final String LAMBDA_A = "lambdaA";
    double lambdaA;
    @S4Double(defaultValue=0.5)
    public static final String LAMBDA_B = "lambdaB";
    double lambdaB;
    @S4Double(defaultValue=0.85)
    public static final String LAMBDA_T = "lambdaT";
    double lambdaT;
    @S4Double(defaultValue=0.2)
    public static final String MU_T = "muT";
    double muT;
    @S4Double(defaultValue=20.0)
    public static final String MAX_GAIN = "maxGain";
    double maxGain;
    @S4Integer(defaultValue=4)
    public static final String SMOOTH_WINDOW = "smoothWindow";
    int smoothWindow;
    static final double EPS = 1.0E-10;

    public Denoise(double lambdaPower, double lambdaA, double lambdaB, double lambdaT, double muT, double maxGain, int smoothWindow) {
        this.lambdaPower = lambdaPower;
        this.lambdaA = lambdaA;
        this.lambdaB = lambdaB;
        this.lambdaT = lambdaT;
        this.muT = muT;
        this.maxGain = maxGain;
        this.smoothWindow = smoothWindow;
    }

    public Denoise() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.lambdaPower = ps.getDouble(LAMBDA_POWER);
        this.lambdaA = ps.getDouble(LAMBDA_A);
        this.lambdaB = ps.getDouble(LAMBDA_B);
        this.lambdaT = ps.getDouble(LAMBDA_T);
        this.muT = ps.getDouble(MU_T);
        this.maxGain = ps.getDouble(MAX_GAIN);
        this.smoothWindow = ps.getInt(SMOOTH_WINDOW);
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data inputData = this.getPredecessor().getData();
        if (inputData instanceof DataStartSignal) {
            this.power = null;
            this.noise = null;
            this.floor = null;
            this.peak = null;
            return inputData;
        }
        if (!(inputData instanceof DoubleData)) {
            return inputData;
        }
        DoubleData inputDoubleData = (DoubleData)inputData;
        double[] input = inputDoubleData.getValues();
        int length = input.length;
        if (this.power == null) {
            this.initStatistics(input, length);
        }
        this.updatePower(input);
        this.estimateEnvelope(this.power, this.noise);
        double[] signal = new double[length];
        int i = 0;
        while (i < length) {
            signal[i] = Math.max(this.power[i] - this.noise[i], 0.0);
            ++i;
        }
        this.estimateEnvelope(signal, this.floor);
        this.tempMasking(signal);
        this.powerBoosting(signal);
        double[] gain = new double[length];
        i = 0;
        while (i < length) {
            gain[i] = signal[i] / (this.power[i] + 1.0E-10);
            gain[i] = Math.min(Math.max(gain[i], 1.0 / this.maxGain), this.maxGain);
            ++i;
        }
        double[] smoothGain = this.smooth(gain);
        i = 0;
        while (i < length) {
            int n = i;
            input[n] = input[n] * smoothGain[i];
            ++i;
        }
        return inputData;
    }

    private double[] smooth(double[] gain) {
        double[] result = new double[gain.length];
        int i = 0;
        while (i < gain.length) {
            int start = Math.max(i - this.smoothWindow, 0);
            int end = Math.min(i + this.smoothWindow + 1, gain.length);
            double sum = 0.0;
            int j = start;
            while (j < end) {
                sum += gain[j];
                ++j;
            }
            result[i] = sum / (double)(end - start);
            ++i;
        }
        return result;
    }

    private void powerBoosting(double[] signal) {
        int i = 0;
        while (i < signal.length) {
            if (signal[i] < this.floor[i]) {
                signal[i] = this.floor[i];
            }
            ++i;
        }
    }

    private void tempMasking(double[] signal) {
        int i = 0;
        while (i < signal.length) {
            double in = signal[i];
            int n = i;
            this.peak[n] = this.peak[n] * this.lambdaT;
            if (signal[i] < this.lambdaT * this.peak[i]) {
                signal[i] = this.peak[i] * this.muT;
            }
            if (in > this.peak[i]) {
                this.peak[i] = in;
            }
            ++i;
        }
    }

    private void updatePower(double[] input) {
        int i = 0;
        while (i < input.length) {
            this.power[i] = this.lambdaPower * this.power[i] + (1.0 - this.lambdaPower) * input[i];
            ++i;
        }
    }

    private void estimateEnvelope(double[] signal, double[] envelope) {
        int i = 0;
        while (i < signal.length) {
            envelope[i] = signal[i] > envelope[i] ? this.lambdaA * envelope[i] + (1.0 - this.lambdaA) * signal[i] : this.lambdaB * envelope[i] + (1.0 - this.lambdaB) * signal[i];
            ++i;
        }
    }

    private void initStatistics(double[] input, int length) {
        this.power = Arrays.copyOf(input, length);
        this.noise = Arrays.copyOf(input, length);
        this.floor = new double[length];
        this.peak = new double[length];
        int i = 0;
        while (i < length) {
            this.floor[i] = input[i] / this.maxGain;
            ++i;
        }
    }
}

