/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.databranch;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.databranch.DataListener;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4ComponentList;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DataBufferProcessor
extends BaseDataProcessor
implements DataListener {
    private final List<Data> featureBuffer = new LinkedList<Data>();
    @S4Boolean(defaultValue=false)
    public static final String PROP_WAIT_IF_EMPTY = "waitIfEmpty";
    private boolean waitIfEmpty;
    @S4Integer(defaultValue=10)
    public static final String PROP_WAIT_TIME_MS = "waitTimeMs";
    private long waitTime;
    @S4Integer(defaultValue=50000)
    public static final String PROP_BUFFER_SIZE = "maxBufferSize";
    private int maxBufferSize;
    @S4ComponentList(type=Configurable.class, beTolerant=true)
    public static final String DATA_LISTENERS = "dataListeners";
    private List<DataListener> dataListeners = new ArrayList<DataListener>();

    public DataBufferProcessor(int maxBufferSize, boolean waitIfEmpty, int waitTime, List<? extends Configurable> listeners) {
        this.initLogger();
        this.maxBufferSize = maxBufferSize;
        this.waitIfEmpty = waitIfEmpty;
        if (waitIfEmpty) {
            this.waitTime = waitTime;
        }
        for (Configurable configurable : listeners) {
            assert (configurable instanceof DataListener);
            this.addDataListener((DataListener)((Object)configurable));
        }
    }

    public DataBufferProcessor() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.maxBufferSize = ps.getInt(PROP_BUFFER_SIZE);
        this.waitIfEmpty = ps.getBoolean(PROP_WAIT_IF_EMPTY);
        if (this.waitIfEmpty) {
            this.waitTime = ps.getInt(PROP_WAIT_TIME_MS);
        }
        this.dataListeners = ps.getComponentList(DATA_LISTENERS, DataListener.class);
    }

    @Override
    public void processDataFrame(Data data) {
        this.featureBuffer.add(data);
        for (DataListener dataListener : this.dataListeners) {
            dataListener.processDataFrame(data);
        }
        while (this.featureBuffer.size() > this.maxBufferSize) {
            this.featureBuffer.remove(0);
        }
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data data = null;
        while (this.waitIfEmpty && this.featureBuffer.isEmpty()) {
            try {
                Thread.sleep(this.waitTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (!this.featureBuffer.isEmpty()) {
            data = this.featureBuffer.remove(0);
        } else assert (!this.waitIfEmpty);
        return data;
    }

    public int getBufferSize() {
        return this.featureBuffer.size();
    }

    public void clearBuffer() {
        this.featureBuffer.clear();
    }

    public List<Data> getBuffer() {
        return Collections.unmodifiableList(this.featureBuffer);
    }

    public void addDataListener(DataListener l) {
        if (l == null) {
            return;
        }
        this.dataListeners.add(l);
    }

    public void removeDataListener(DataListener l) {
        if (l == null) {
            return;
        }
        this.dataListeners.remove(l);
    }
}

