/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search.stats;

import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.linguist.HMMSearchState;
import java.util.HashMap;
import java.util.Map;

public class TokenTracker {
    private Map<Object, TokenStats> stateMap;
    private boolean enabled;
    private int frame;
    private int utteranceStateCount;
    private int utteranceMaxStates;
    private int utteranceSumStates;

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    void startUtterance() {
        if (this.enabled) {
            this.frame = 0;
            this.utteranceStateCount = 0;
            this.utteranceMaxStates = -2147483647;
            this.utteranceSumStates = 0;
        }
    }

    void stopUtterance() {
        if (this.enabled) {
            this.dumpSummary();
        }
    }

    void startFrame() {
        if (this.enabled) {
            this.stateMap = new HashMap<Object, TokenStats>();
        }
    }

    public void add(Token t) {
        if (this.enabled) {
            TokenStats stats = this.getStats(t);
            stats.update(t);
        }
    }

    void stopFrame() {
        if (this.enabled) {
            ++this.frame;
            this.dumpDetails();
        }
    }

    public void dumpSummary() {
        if (this.enabled) {
            float avgStates = 0.0f;
            if (this.utteranceStateCount > 0) {
                avgStates = (float)this.utteranceSumStates / (float)this.utteranceStateCount;
            }
            System.out.print("# Utterance stats ");
            System.out.print(" States: " + this.utteranceStateCount / this.frame);
            if (this.utteranceStateCount > 0) {
                System.out.print(" Paths: " + this.utteranceSumStates / this.frame);
                System.out.print(" Max: " + this.utteranceMaxStates);
                System.out.print(" Avg: " + avgStates);
            }
            System.out.println();
        }
    }

    public void dumpDetails() {
        if (this.enabled) {
            int maxStates = -2147483647;
            int hmmCount = 0;
            int sumStates = 0;
            for (TokenStats stats : this.stateMap.values()) {
                if (stats.isHMM) {
                    ++hmmCount;
                }
                sumStates += stats.count;
                this.utteranceSumStates += stats.count;
                if (stats.count > maxStates) {
                    maxStates = stats.count;
                }
                if (stats.count <= this.utteranceMaxStates) continue;
                this.utteranceMaxStates = stats.count;
            }
            this.utteranceStateCount += this.stateMap.size();
            float avgStates = 0.0f;
            if (!this.stateMap.isEmpty()) {
                avgStates = (float)sumStates / (float)this.stateMap.size();
            }
            System.out.print("# Frame " + this.frame);
            System.out.print(" States: " + this.stateMap.size());
            if (!this.stateMap.isEmpty()) {
                System.out.print(" Paths: " + sumStates);
                System.out.print(" Max: " + maxStates);
                System.out.print(" Avg: " + avgStates);
                System.out.print(" HMM: " + hmmCount);
            }
            System.out.println();
        }
    }

    private TokenStats getStats(Token t) {
        TokenStats stats = this.stateMap.get(t.getSearchState().getLexState());
        if (stats == null) {
            stats = new TokenStats();
            this.stateMap.put(t.getSearchState().getLexState(), stats);
        }
        return stats;
    }

    class TokenStats {
        int count = 0;
        float maxScore = -3.4028235E38f;
        float minScore = Float.MIN_VALUE;
        boolean isHMM;

        TokenStats() {
        }

        public void update(Token t) {
            ++this.count;
            if (t.getScore() > this.maxScore) {
                this.maxScore = t.getScore();
            }
            if (t.getScore() < this.minScore) {
                this.minScore = t.getScore();
            }
            this.isHMM = t.getSearchState() instanceof HMMSearchState;
        }
    }
}

