/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.pruner.Pruner;
import edu.cmu.sphinx.decoder.scorer.AcousticScorer;
import edu.cmu.sphinx.decoder.search.ActiveList;
import edu.cmu.sphinx.decoder.search.ActiveListFactory;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.decoder.search.TokenSearchManager;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.StatisticsVariable;
import edu.cmu.sphinx.util.Timer;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleBreadthFirstSearchManager
extends TokenSearchManager {
    @S4Component(type=Linguist.class)
    public static final String PROP_LINGUIST = "linguist";
    @S4Component(type=Pruner.class)
    public static final String PROP_PRUNER = "pruner";
    @S4Component(type=AcousticScorer.class)
    public static final String PROP_SCORER = "scorer";
    @S4Component(type=ActiveListFactory.class)
    public static final String PROP_ACTIVE_LIST_FACTORY = "activeListFactory";
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_TOKEN_COUNT = "showTokenCount";
    @S4Double(defaultValue=0.0)
    public static final String PROP_RELATIVE_WORD_BEAM_WIDTH = "relativeWordBeamWidth";
    @S4Boolean(defaultValue=false)
    public static final String PROP_WANT_ENTRY_PRUNING = "wantEntryPruning";
    @S4Integer(defaultValue=0)
    public static final String PROP_GROW_SKIP_INTERVAL = "growSkipInterval";
    protected Linguist linguist;
    private Pruner pruner;
    private AcousticScorer scorer;
    protected int currentFrameNumber;
    protected long currentCollectTime;
    protected ActiveList activeList;
    protected List<Token> resultList;
    protected LogMath logMath;
    private Logger logger;
    private String name;
    private Timer scoreTimer;
    private Timer pruneTimer;
    protected Timer growTimer;
    private StatisticsVariable totalTokensScored;
    private StatisticsVariable tokensPerSecond;
    private StatisticsVariable curTokensScored;
    private StatisticsVariable tokensCreated;
    private StatisticsVariable viterbiPruned;
    private StatisticsVariable beamPruned;
    protected boolean showTokenCount;
    private boolean wantEntryPruning;
    protected Map<SearchState, Token> bestTokenMap;
    private float logRelativeWordBeamWidth;
    private int totalHmms;
    private double startTime;
    private float threshold;
    private float wordThreshold;
    private int growSkipInterval;
    protected ActiveListFactory activeListFactory;
    protected boolean streamEnd;

    public SimpleBreadthFirstSearchManager() {
    }

    public SimpleBreadthFirstSearchManager(Linguist linguist, Pruner pruner, AcousticScorer scorer, ActiveListFactory activeListFactory, boolean showTokenCount, double relativeWordBeamWidth, int growSkipInterval, boolean wantEntryPruning) {
        this.name = this.getClass().getName();
        this.logger = Logger.getLogger(this.name);
        this.logMath = LogMath.getLogMath();
        this.linguist = linguist;
        this.pruner = pruner;
        this.scorer = scorer;
        this.activeListFactory = activeListFactory;
        this.showTokenCount = showTokenCount;
        this.growSkipInterval = growSkipInterval;
        this.wantEntryPruning = wantEntryPruning;
        this.logRelativeWordBeamWidth = this.logMath.linearToLog(relativeWordBeamWidth);
        this.keepAllTokens = true;
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.logMath = LogMath.getLogMath();
        this.logger = ps.getLogger();
        this.name = ps.getInstanceName();
        this.linguist = (Linguist)ps.getComponent(PROP_LINGUIST);
        this.pruner = (Pruner)ps.getComponent(PROP_PRUNER);
        this.scorer = (AcousticScorer)ps.getComponent(PROP_SCORER);
        this.activeListFactory = (ActiveListFactory)ps.getComponent(PROP_ACTIVE_LIST_FACTORY);
        this.showTokenCount = ps.getBoolean(PROP_SHOW_TOKEN_COUNT);
        double relativeWordBeamWidth = ps.getDouble(PROP_RELATIVE_WORD_BEAM_WIDTH);
        this.growSkipInterval = ps.getInt(PROP_GROW_SKIP_INTERVAL);
        this.wantEntryPruning = ps.getBoolean(PROP_WANT_ENTRY_PRUNING);
        this.logRelativeWordBeamWidth = this.logMath.linearToLog(relativeWordBeamWidth);
        this.keepAllTokens = true;
    }

    @Override
    public void startRecognition() {
        this.logger.finer("starting recognition");
        this.linguist.startRecognition();
        this.pruner.startRecognition();
        this.scorer.startRecognition();
        this.localStart();
        if (this.startTime == 0.0) {
            this.startTime = System.currentTimeMillis();
        }
    }

    @Override
    public Result recognize(int nFrames) {
        boolean done = false;
        Result result = null;
        this.streamEnd = false;
        int i = 0;
        while (i < nFrames && !done) {
            done = this.recognize();
            ++i;
        }
        if (this.activeList.getBestToken() != null) {
            ActiveList fixedList = this.undoLastGrowStep();
            if (!this.streamEnd) {
                result = new Result(fixedList, this.resultList, this.currentFrameNumber, done, this.linguist.getSearchGraph().getWordTokenFirst(), false);
            }
        }
        if (this.showTokenCount) {
            this.showTokenCount();
        }
        return result;
    }

    protected ActiveList undoLastGrowStep() {
        ActiveList fixedList = this.activeList.newInstance();
        for (Token token : this.activeList) {
            Token curToken = token.getPredecessor();
            while (curToken.getPredecessor() != null && (curToken.isFinal() && curToken.getPredecessor() != null && !curToken.getPredecessor().isFinal() || curToken.isEmitting() && curToken.getData() == null || !curToken.isFinal() && !curToken.isEmitting())) {
                curToken = curToken.getPredecessor();
            }
            fixedList.add(curToken);
        }
        return fixedList;
    }

    @Override
    public void stopRecognition() {
        this.localStop();
        this.scorer.stopRecognition();
        this.pruner.stopRecognition();
        this.linguist.stopRecognition();
        this.logger.finer("recognition stopped");
    }

    protected boolean recognize() {
        boolean more = this.scoreTokens();
        if (more) {
            this.pruneBranches();
            ++this.currentFrameNumber;
            if (this.growSkipInterval == 0 || this.currentFrameNumber % this.growSkipInterval != 0) {
                this.growBranches();
            }
        }
        return !more;
    }

    protected void localStart() {
        this.currentFrameNumber = 0;
        this.curTokensScored.value = 0.0;
        ActiveList newActiveList = this.activeListFactory.newInstance();
        SearchState state = this.linguist.getSearchGraph().getInitialState();
        newActiveList.add(new Token(state, -1L));
        this.activeList = newActiveList;
        this.growBranches();
    }

    protected void localStop() {
    }

    protected void growBranches() {
        int mapSize = this.activeList.size() * 10;
        if (mapSize == 0) {
            mapSize = 1;
        }
        this.growTimer.start();
        this.bestTokenMap = new HashMap<SearchState, Token>(mapSize);
        ActiveList oldActiveList = this.activeList;
        this.resultList = new LinkedList<Token>();
        this.activeList = this.activeListFactory.newInstance();
        this.threshold = oldActiveList.getBeamThreshold();
        this.wordThreshold = oldActiveList.getBestScore() + this.logRelativeWordBeamWidth;
        for (Token token : oldActiveList) {
            this.collectSuccessorTokens(token);
        }
        this.growTimer.stop();
        if (this.logger.isLoggable(Level.FINE)) {
            int hmms = this.activeList.size();
            this.totalHmms += hmms;
            this.logger.fine("Frame: " + this.currentFrameNumber + " Hmms: " + hmms + "  total " + this.totalHmms);
        }
    }

    protected boolean scoreTokens() {
        boolean hasMoreFrames = false;
        this.scoreTimer.start();
        Data data = this.scorer.calculateScores(this.activeList.getTokens());
        this.scoreTimer.stop();
        Token bestToken = null;
        if (data instanceof Token) {
            bestToken = (Token)data;
        } else if (data == null) {
            this.streamEnd = true;
        }
        if (bestToken != null) {
            hasMoreFrames = true;
            this.currentCollectTime = bestToken.getCollectTime();
            this.activeList.setBestToken(bestToken);
        }
        this.curTokensScored.value += (double)this.activeList.size();
        this.totalTokensScored.value += (double)this.activeList.size();
        this.tokensPerSecond.value = this.totalTokensScored.value / this.getTotalTime();
        return hasMoreFrames;
    }

    private double getTotalTime() {
        return ((double)System.currentTimeMillis() - this.startTime) / 1000.0;
    }

    protected void pruneBranches() {
        int startSize = this.activeList.size();
        this.pruneTimer.start();
        this.activeList = this.pruner.prune(this.activeList);
        this.beamPruned.value += (double)(startSize - this.activeList.size());
        this.pruneTimer.stop();
    }

    protected Token getBestToken(SearchState state) {
        Token best = this.bestTokenMap.get(state);
        if (this.logger.isLoggable(Level.FINER) && best != null) {
            this.logger.finer("BT " + best + " for state " + state);
        }
        return best;
    }

    protected Token setBestToken(Token token, SearchState state) {
        return this.bestTokenMap.put(state, token);
    }

    public ActiveList getActiveList() {
        return this.activeList;
    }

    protected void collectSuccessorTokens(Token token) {
        SearchStateArc[] arcs;
        SearchState state = token.getSearchState();
        if (token.isFinal()) {
            this.resultList.add(token);
        }
        if (token.getScore() < this.threshold) {
            return;
        }
        if (state instanceof WordSearchState && token.getScore() < this.wordThreshold) {
            return;
        }
        SearchStateArc[] searchStateArcArray = arcs = state.getSuccessors();
        int n = arcs.length;
        int n2 = 0;
        while (n2 < n) {
            SearchStateArc arc = searchStateArcArray[n2];
            SearchState nextState = arc.getState();
            float logEntryScore = token.getScore() + arc.getProbability();
            if (!(this.wantEntryPruning && (logEntryScore < this.threshold || nextState instanceof WordSearchState && logEntryScore < this.wordThreshold))) {
                Token predecessor = this.getResultListPredecessor(token);
                if (!nextState.isEmitting()) {
                    Token newToken = new Token(predecessor, nextState, logEntryScore, arc.getInsertionProbability(), arc.getLanguageProbability(), this.currentCollectTime);
                    this.tokensCreated.value += 1.0;
                    if (!this.isVisited(newToken)) {
                        this.collectSuccessorTokens(newToken);
                    }
                } else {
                    Token bestToken = this.getBestToken(nextState);
                    if (bestToken == null) {
                        Token newToken = new Token(predecessor, nextState, logEntryScore, arc.getInsertionProbability(), arc.getLanguageProbability(), this.currentFrameNumber);
                        this.tokensCreated.value += 1.0;
                        this.setBestToken(newToken, nextState);
                        this.activeList.add(newToken);
                    } else if (bestToken.getScore() <= logEntryScore) {
                        bestToken.update(predecessor, nextState, logEntryScore, arc.getInsertionProbability(), arc.getLanguageProbability(), this.currentCollectTime);
                        this.viterbiPruned.value += 1.0;
                    } else {
                        this.viterbiPruned.value += 1.0;
                    }
                }
            }
            ++n2;
        }
    }

    private boolean isVisited(Token t) {
        SearchState curState = t.getSearchState();
        t = t.getPredecessor();
        while (t != null && !t.isEmitting()) {
            if (curState.equals(t.getSearchState())) {
                return true;
            }
            t = t.getPredecessor();
        }
        return false;
    }

    protected void showTokenCount() {
        if (this.logger.isLoggable(Level.INFO)) {
            HashSet<Token> tokenSet = new HashSet<Token>();
            for (Token token : this.activeList) {
                while (token != null) {
                    tokenSet.add(token);
                    token = token.getPredecessor();
                }
            }
            this.logger.info("Token Lattice size: " + tokenSet.size());
            tokenSet = new HashSet();
            for (Token token : this.resultList) {
                while (token != null) {
                    tokenSet.add(token);
                    token = token.getPredecessor();
                }
            }
            this.logger.info("Result Lattice size: " + tokenSet.size());
        }
    }

    protected Map<SearchState, Token> getBestTokenMap() {
        return this.bestTokenMap;
    }

    protected void setBestTokenMap(Map<SearchState, Token> bestTokenMap) {
        this.bestTokenMap = bestTokenMap;
    }

    public List<Token> getResultList() {
        return this.resultList;
    }

    public int getCurrentFrameNumber() {
        return this.currentFrameNumber;
    }

    public Timer getGrowTimer() {
        return this.growTimer;
    }

    public StatisticsVariable getTokensCreated() {
        return this.tokensCreated;
    }

    @Override
    public void allocate() {
        this.totalTokensScored = StatisticsVariable.getStatisticsVariable("totalTokensScored");
        this.tokensPerSecond = StatisticsVariable.getStatisticsVariable("tokensScoredPerSecond");
        this.curTokensScored = StatisticsVariable.getStatisticsVariable("curTokensScored");
        this.tokensCreated = StatisticsVariable.getStatisticsVariable("tokensCreated");
        this.viterbiPruned = StatisticsVariable.getStatisticsVariable("viterbiPruned");
        this.beamPruned = StatisticsVariable.getStatisticsVariable("beamPruned");
        try {
            this.linguist.allocate();
            this.pruner.allocate();
            this.scorer.allocate();
        }
        catch (IOException e) {
            throw new RuntimeException("Allocation of search manager resources failed", e);
        }
        this.scoreTimer = TimerPool.getTimer(this, "Score");
        this.pruneTimer = TimerPool.getTimer(this, "Prune");
        this.growTimer = TimerPool.getTimer(this, "Grow");
    }

    @Override
    public void deallocate() {
        try {
            this.scorer.deallocate();
            this.pruner.deallocate();
            this.linguist.deallocate();
        }
        catch (IOException e) {
            throw new RuntimeException("Deallocation of search manager resources failed", e);
        }
    }

    public String toString() {
        return this.name;
    }
}

