/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.scorer.Scoreable;
import edu.cmu.sphinx.decoder.search.ActiveList;
import edu.cmu.sphinx.decoder.search.ActiveListFactory;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SimpleActiveListFactory
extends ActiveListFactory {
    public SimpleActiveListFactory(int absoluteBeamWidth, double relativeBeamWidth) {
        super(absoluteBeamWidth, relativeBeamWidth);
    }

    public SimpleActiveListFactory() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
    }

    @Override
    public ActiveList newInstance() {
        return new SimpleActiveList(this.absoluteBeamWidth, this.logRelativeBeamWidth);
    }

    class SimpleActiveList
    implements ActiveList {
        private int absoluteBeamWidth = 2000;
        private final float logRelativeBeamWidth;
        private Token bestToken;
        private List<Token> tokenList = new LinkedList<Token>();

        public SimpleActiveList(int absoluteBeamWidth, float logRelativeBeamWidth) {
            this.absoluteBeamWidth = absoluteBeamWidth;
            this.logRelativeBeamWidth = logRelativeBeamWidth;
        }

        @Override
        public void add(Token token) {
            this.tokenList.add(token);
            if (this.bestToken == null || token.getScore() > this.bestToken.getScore()) {
                this.bestToken = token;
            }
        }

        public void replace(Token oldToken, Token newToken) {
            this.add(newToken);
            if (oldToken != null) {
                this.tokenList.remove(oldToken);
            }
        }

        @Override
        public ActiveList purge() {
            if (this.absoluteBeamWidth > 0 && this.tokenList.size() > this.absoluteBeamWidth) {
                Collections.sort(this.tokenList, Scoreable.COMPARATOR);
                this.tokenList = this.tokenList.subList(0, this.absoluteBeamWidth);
            }
            return this;
        }

        @Override
        public Iterator<Token> iterator() {
            return this.tokenList.iterator();
        }

        @Override
        public List<Token> getTokens() {
            return this.tokenList;
        }

        @Override
        public final int size() {
            return this.tokenList.size();
        }

        @Override
        public float getBeamThreshold() {
            return this.getBestScore() + this.logRelativeBeamWidth;
        }

        @Override
        public float getBestScore() {
            float bestScore = -3.4028235E38f;
            if (this.bestToken != null) {
                bestScore = this.bestToken.getScore();
            }
            return bestScore;
        }

        @Override
        public void setBestToken(Token token) {
            this.bestToken = token;
        }

        @Override
        public Token getBestToken() {
            return this.bestToken;
        }

        @Override
        public ActiveList newInstance() {
            return SimpleActiveListFactory.this.newInstance();
        }
    }
}

