/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.scorer.Scoreable;
import edu.cmu.sphinx.decoder.search.Token;
import java.util.Arrays;

public class Partitioner {
    private final int MAX_DEPTH = 50;

    private int endPointPartition(Token[] tokens, int start, int end) {
        Token pivot = tokens[end];
        float pivotScore = pivot.getScore();
        int i = start;
        int j = end - 1;
        while (true) {
            if (i < end && tokens[i].getScore() >= pivotScore) {
                ++i;
                continue;
            }
            while (j > i && tokens[j].getScore() < pivotScore) {
                --j;
            }
            if (j <= i) break;
            Token current = tokens[j];
            this.setToken(tokens, j, tokens[i]);
            this.setToken(tokens, i, current);
        }
        this.setToken(tokens, end, tokens[i]);
        this.setToken(tokens, i, pivot);
        return i;
    }

    private int midPointPartition(Token[] tokens, int start, int end) {
        int middle = start + end >>> 1;
        Token temp = tokens[end];
        this.setToken(tokens, end, tokens[middle]);
        this.setToken(tokens, middle, temp);
        return this.endPointPartition(tokens, start, end);
    }

    public int partition(Token[] tokens, int size, int n) {
        if (tokens.length > n) {
            return this.midPointSelect(tokens, 0, size - 1, n, 0);
        }
        return this.findBest(tokens, size);
    }

    private int findBest(Token[] tokens, int size) {
        int r = -1;
        float lowestScore = Float.MAX_VALUE;
        int i = 0;
        while (i < tokens.length) {
            float currentScore = tokens[i].getScore();
            if (currentScore <= lowestScore) {
                lowestScore = currentScore;
                r = i;
            }
            ++i;
        }
        int last = size - 1;
        if (last >= 0) {
            Token lastToken = tokens[last];
            this.setToken(tokens, last, tokens[r]);
            this.setToken(tokens, r, lastToken);
        }
        return last;
    }

    private void setToken(Token[] list, int index, Token token) {
        list[index] = token;
    }

    private int midPointSelect(Token[] tokens, int start, int end, int targetSize, int depth) {
        if (depth > 50) {
            return this.simplePointSelect(tokens, start, end, targetSize);
        }
        if (start == end) {
            return start;
        }
        int partitionToken = this.midPointPartition(tokens, start, end);
        int newSize = partitionToken - start + 1;
        if (targetSize == newSize) {
            return partitionToken;
        }
        if (targetSize < newSize) {
            return this.midPointSelect(tokens, start, partitionToken - 1, targetSize, depth + 1);
        }
        return this.midPointSelect(tokens, partitionToken + 1, end, targetSize - newSize, depth + 1);
    }

    private int simplePointSelect(Token[] tokens, int start, int end, int targetSize) {
        Arrays.sort(tokens, start, end + 1, Scoreable.COMPARATOR);
        return start + targetSize - 1;
    }
}

