/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.adaptation;

import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.math3.util.FastMath;

public class ClusteredDensityFileData {
    private int numberOfClusters;
    private int[] corespondingClass;

    public ClusteredDensityFileData(Loader loader, int numberOfClusters) {
        this.numberOfClusters = numberOfClusters;
        this.kMeansClustering(loader, 30);
    }

    public int getNumberOfClusters() {
        return this.numberOfClusters;
    }

    public int getClassIndex(int gaussian) {
        return this.corespondingClass[gaussian];
    }

    private float euclidianDistance(float[] a, float[] b) {
        double s = 0.0;
        int i = 0;
        while (i < a.length) {
            double d = a[i] - b[i];
            s += d * d;
            ++i;
        }
        return (float)FastMath.sqrt((double)s);
    }

    private boolean isEqual(float[] a, float[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void kMeansClustering(Loader loader, int maxIterations) {
        int index;
        Pool<float[]> initialData = loader.getMeansPool();
        ArrayList<float[]> oldCentroids = new ArrayList<float[]>(this.numberOfClusters);
        ArrayList<float[]> centroids = new ArrayList<float[]>(this.numberOfClusters);
        int numberOfElements = initialData.size();
        int nrOfIterations = maxIterations;
        int[] count = new int[this.numberOfClusters];
        float[][][] array = new float[this.numberOfClusters][numberOfElements][];
        boolean converged = false;
        Random randomGenerator = new Random();
        int i = 0;
        while (i < this.numberOfClusters) {
            index = randomGenerator.nextInt(numberOfElements);
            centroids.add(initialData.get(index));
            oldCentroids.add(initialData.get(index));
            count[i] = 0;
            ++i;
        }
        index = 0;
        while (!converged && nrOfIterations > 0) {
            int k;
            this.corespondingClass = new int[initialData.size()];
            array = new float[this.numberOfClusters][numberOfElements][];
            i = 0;
            while (i < this.numberOfClusters) {
                oldCentroids.set(i, (float[])centroids.get(i));
                count[i] = 0;
                ++i;
            }
            i = 0;
            while (i < initialData.size()) {
                float[] currentValue = initialData.get(i);
                double min = this.euclidianDistance((float[])oldCentroids.get(0), currentValue);
                index = 0;
                k = 1;
                while (k < this.numberOfClusters) {
                    double distance = this.euclidianDistance((float[])oldCentroids.get(k), currentValue);
                    if (distance < min) {
                        min = distance;
                        index = k;
                    }
                    ++k;
                }
                array[index][count[index]] = currentValue;
                this.corespondingClass[i] = index;
                int n = index;
                count[n] = count[n] + 1;
                ++i;
            }
            i = 0;
            while (i < this.numberOfClusters) {
                float[] centroid = new float[initialData.get(0).length];
                if (count[i] > 0) {
                    int j = 0;
                    while (j < count[i]) {
                        int k2 = 0;
                        while (k2 < initialData.get(0).length) {
                            int n = k2;
                            centroid[n] = centroid[n] + array[i][j][k2];
                            ++k2;
                        }
                        ++j;
                    }
                    k = 0;
                    while (k < initialData.get(0).length) {
                        int n = k++;
                        centroid[n] = centroid[n] / (float)count[i];
                    }
                    centroids.set(i, centroid);
                }
                ++i;
            }
            converged = true;
            i = 0;
            while (i < this.numberOfClusters) {
                converged = converged && this.isEqual((float[])centroids.get(i), (float[])oldCentroids.get(i));
                ++i;
            }
            --nrOfIterations;
        }
    }
}

