/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.api;

import edu.cmu.sphinx.api.Configuration;
import edu.cmu.sphinx.frontend.util.StreamDataSource;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.util.TimeFrame;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;

public class Context {
    private final ConfigurationManager configurationManager;

    public Context(Configuration config) throws IOException, MalformedURLException {
        this("resource:/edu/cmu/sphinx/api/default.config.xml", config);
    }

    public Context(String path, Configuration config) throws IOException, MalformedURLException {
        this.configurationManager = new ConfigurationManager(ConfigurationManagerUtils.resourceToURL(path));
        this.setAcousticModel(config.getAcousticModelPath());
        this.setDictionary(config.getDictionaryPath());
        if (config.getGrammarPath() != null && config.getUseGrammar()) {
            this.setGrammar(config.getGrammarPath(), config.getGrammarName());
        }
        if (config.getLanguageModelPath() != null && !config.getUseGrammar()) {
            this.setLanguageModel(config.getLanguageModelPath());
        }
        this.setSampleRate(config.getSampleRate());
        this.configurationManager.lookup("recognizer");
    }

    public void setAcousticModel(String path) throws IOException {
        this.setLocalProperty("acousticModelLoader->location", path);
        this.setLocalProperty("dictionary->fillerPath", Utilities.pathJoin(path, "noisedict"));
    }

    public void setDictionary(String path) {
        this.setLocalProperty("dictionary->dictionaryPath", path);
    }

    public void setSampleRate(int sampleRate) {
        this.setLocalProperty("dataSource->sampleRate", Integer.toString(sampleRate));
    }

    public void setGrammar(String path, String name) {
        if (name.endsWith(".grxml")) {
            this.setLocalProperty("grXmlGrammar->grammarLocation", String.valueOf(path) + name);
            this.setLocalProperty("flatLinguist->grammar", "grXmlGrammar");
        } else {
            this.setLocalProperty("jsgfGrammar->grammarLocation", path);
            this.setLocalProperty("jsgfGrammar->grammarName", name);
            this.setLocalProperty("flatLinguist->grammar", "jsgfGrammar");
        }
        this.setLocalProperty("decoder->searchManager", "simpleSearchManager");
    }

    public void setLanguageModel(String path) {
        if (path.endsWith(".lm")) {
            this.setLocalProperty("simpleNGramModel->location", path);
            this.setLocalProperty("lexTreeLinguist->languageModel", "simpleNGramModel");
        } else if (path.endsWith(".dmp")) {
            this.setLocalProperty("largeTrigramModel->location", path);
            this.setLocalProperty("lexTreeLinguist->languageModel", "largeTrigramModel");
        } else if (path.endsWith(".bin")) {
            this.setLocalProperty("trieNgramModel->location", path);
            this.setLocalProperty("lexTreeLinguist->languageModel", "trieNgramModel");
        } else {
            throw new IllegalArgumentException("Unknown format extension: " + path);
        }
    }

    public void setSpeechSource(InputStream stream, TimeFrame timeFrame) {
        this.getInstance(StreamDataSource.class).setInputStream(stream, timeFrame);
        this.setLocalProperty("trivialScorer->frontend", "liveFrontEnd");
    }

    public void setSpeechSource(InputStream stream) {
        this.getInstance(StreamDataSource.class).setInputStream(stream);
        this.setLocalProperty("trivialScorer->frontend", "liveFrontEnd");
    }

    public void setLocalProperty(String name, Object value) {
        ConfigurationManagerUtils.setProperty(this.configurationManager, name, value.toString());
    }

    public void setGlobalProperty(String name, Object value) {
        this.configurationManager.setGlobalProperty(name, value.toString());
    }

    public <C extends Configurable> C getInstance(Class<C> clazz) {
        return this.configurationManager.lookup(clazz);
    }

    public Loader getLoader() {
        return (Loader)this.configurationManager.lookup("acousticModelLoader");
    }
}

