/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.api;

import edu.cmu.sphinx.api.Configuration;
import edu.cmu.sphinx.api.Context;
import edu.cmu.sphinx.api.SpeechResult;
import edu.cmu.sphinx.api.SpeechSourceProvider;
import edu.cmu.sphinx.decoder.adaptation.ClusteredDensityFileData;
import edu.cmu.sphinx.decoder.adaptation.Stats;
import edu.cmu.sphinx.decoder.adaptation.Transform;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Sphinx3Loader;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.result.Result;
import java.io.IOException;

public class AbstractSpeechRecognizer {
    protected final Context context;
    protected final Recognizer recognizer;
    protected ClusteredDensityFileData clusters;
    protected final SpeechSourceProvider speechSourceProvider;

    public AbstractSpeechRecognizer(Configuration configuration) throws IOException {
        this(new Context(configuration));
    }

    protected AbstractSpeechRecognizer(Context context) throws IOException {
        this.context = context;
        this.recognizer = context.getInstance(Recognizer.class);
        this.speechSourceProvider = new SpeechSourceProvider();
    }

    public SpeechResult getResult() {
        Result result = this.recognizer.recognize();
        return result == null ? null : new SpeechResult(result);
    }

    public Stats createStats(int numClasses) {
        this.clusters = new ClusteredDensityFileData(this.context.getLoader(), numClasses);
        return new Stats(this.context.getLoader(), this.clusters);
    }

    public void setTransform(Transform transform) {
        if (this.clusters != null && transform != null) {
            this.context.getLoader().update(transform, this.clusters);
        }
    }

    public void loadTransform(String path, int numClass) throws Exception {
        this.clusters = new ClusteredDensityFileData(this.context.getLoader(), numClass);
        Transform transform = new Transform((Sphinx3Loader)this.context.getLoader(), numClass);
        transform.load(path);
        this.context.getLoader().update(transform, this.clusters);
    }
}

