/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.alignment.tokenizer;

import edu.cmu.sphinx.alignment.USEnglishTokenizer;
import edu.cmu.sphinx.alignment.tokenizer.FeatureSet;
import edu.cmu.sphinx.alignment.tokenizer.Item;
import edu.cmu.sphinx.alignment.tokenizer.Relation;
import edu.cmu.sphinx.alignment.tokenizer.Utterance;

public class WordRelation {
    private Relation relation;
    private USEnglishTokenizer tokenToWords;

    private WordRelation(Relation parentRelation, USEnglishTokenizer tokenToWords) {
        this.relation = parentRelation;
        this.tokenToWords = tokenToWords;
    }

    public static WordRelation createWordRelation(Utterance utterance, USEnglishTokenizer tokenToWords) {
        Relation relation = utterance.createRelation("Word");
        return new WordRelation(relation, tokenToWords);
    }

    public void addBreak() {
        Item wordItem = this.relation.getTail();
        if (wordItem != null) {
            FeatureSet featureSet = wordItem.getFeatures();
            featureSet.setString("break", "1");
        }
    }

    public void addWord(String word) {
        Item tokenItem = this.tokenToWords.getTokenItem();
        Item wordItem = tokenItem.createDaughter();
        FeatureSet featureSet = wordItem.getFeatures();
        featureSet.setString("name", word);
        this.relation.appendItem(wordItem);
    }

    public void setLastWord(String word) {
        Item lastItem = this.relation.getTail();
        FeatureSet featureSet = lastItem.getFeatures();
        featureSet.setString("name", word);
    }

    public Item getTail() {
        return this.relation.getTail();
    }
}

