/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.alignment.tokenizer;

import edu.cmu.sphinx.alignment.Token;
import edu.cmu.sphinx.alignment.tokenizer.CharTokenizer;
import edu.cmu.sphinx.alignment.tokenizer.FeatureSet;
import edu.cmu.sphinx.alignment.tokenizer.Item;
import edu.cmu.sphinx.alignment.tokenizer.PathExtractor;
import edu.cmu.sphinx.alignment.tokenizer.Relation;
import java.util.Iterator;

public class Utterance {
    private FeatureSet features = new FeatureSet();
    private FeatureSet relations = new FeatureSet();

    public Utterance(CharTokenizer tokenizer) {
        this.setTokenList(tokenizer);
    }

    public Relation createRelation(String name) {
        Relation relation = new Relation(name, this);
        this.relations.setObject(name, relation);
        return relation;
    }

    public Relation getRelation(String name) {
        return (Relation)this.relations.getObject(name);
    }

    public boolean hasRelation(String name) {
        return this.relations.isPresent(name);
    }

    public void remove(String name) {
        this.features.remove(name);
    }

    public void setInt(String name, int value) {
        this.features.setInt(name, value);
    }

    public void setFloat(String name, float value) {
        this.features.setFloat(name, value);
    }

    public void setString(String name, String value) {
        this.features.setString(name, value);
    }

    public void setObject(String name, Object value) {
        this.features.setObject(name, value);
    }

    public Item getItem(String relation, float time) {
        String pathName = null;
        if (relation.equals("Word")) {
            pathName = "R:SylStructure.parent.parent.R:Word";
        } else if (relation.equals("Token")) {
            pathName = "R:SylStructure.parent.parent.R:Token.parent";
        } else {
            throw new IllegalArgumentException("Utterance.getItem(): relation cannot be " + relation);
        }
        PathExtractor path = new PathExtractor(pathName, false);
        Item segmentItem = Utterance.getItem(this.getRelation(relation), time);
        if (segmentItem != null) {
            return path.findItem(segmentItem);
        }
        return null;
    }

    private static Item getItem(Relation segmentRelation, float time) {
        Item lastSegment = segmentRelation.getTail();
        float lastSegmentEndTime = Utterance.getSegmentEnd(lastSegment);
        if (time < 0.0f || lastSegmentEndTime < time) {
            return null;
        }
        if (lastSegmentEndTime - time > time) {
            return Utterance.findFromFront(segmentRelation, time);
        }
        return Utterance.findFromEnd(segmentRelation, time);
    }

    private static Item findFromEnd(Relation segmentRelation, float time) {
        Item item = segmentRelation.getTail();
        while (item != null && Utterance.getSegmentEnd(item) > time) {
            item = item.getPrevious();
        }
        if (item != segmentRelation.getTail()) {
            item = item.getNext();
        }
        return item;
    }

    private static Item findFromFront(Relation segmentRelation, float time) {
        Item item = segmentRelation.getHead();
        while (item != null && time > Utterance.getSegmentEnd(item)) {
            item = item.getNext();
        }
        return item;
    }

    private static float getSegmentEnd(Item segment) {
        FeatureSet segmentFeatureSet = segment.getFeatures();
        return segmentFeatureSet.getFloat("end");
    }

    private void setTokenList(Iterator<Token> tokenizer) {
        Relation relation = this.createRelation("Token");
        while (tokenizer.hasNext()) {
            Token token = tokenizer.next();
            String tokenWord = token.getWord();
            if (tokenWord == null || tokenWord.length() <= 0) continue;
            Item item = relation.appendItem();
            FeatureSet featureSet = item.getFeatures();
            featureSet.setString("name", tokenWord);
            featureSet.setString("whitespace", token.getWhitespace());
            featureSet.setString("prepunctuation", token.getPrepunctuation());
            featureSet.setString("punc", token.getPostpunctuation());
            featureSet.setString("file_pos", String.valueOf(token.getPosition()));
            featureSet.setString("line_number", String.valueOf(token.getLineNumber()));
        }
    }
}

