/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.alignment.tokenizer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;

public class PronounceableFSM {
    private static final String VOCAB_SIZE = "VOCAB_SIZE";
    private static final String NUM_OF_TRANSITIONS = "NUM_OF_TRANSITIONS";
    private static final String TRANSITIONS = "TRANSITIONS";
    protected int vocabularySize;
    protected int[] transitions;
    protected boolean scanFromFront;

    public PronounceableFSM(URL url, boolean scanFromFront) throws IOException {
        this.scanFromFront = scanFromFront;
        InputStream is = url.openStream();
        this.loadText(is);
        is.close();
    }

    public PronounceableFSM(int vocabularySize, int[] transitions, boolean scanFromFront) {
        this.vocabularySize = vocabularySize;
        this.transitions = transitions;
        this.scanFromFront = scanFromFront;
    }

    private void loadText(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("***")) continue;
            if (line.startsWith(VOCAB_SIZE)) {
                this.vocabularySize = this.parseLastInt(line);
                continue;
            }
            if (line.startsWith(NUM_OF_TRANSITIONS)) {
                int transitionsSize = this.parseLastInt(line);
                this.transitions = new int[transitionsSize];
                continue;
            }
            if (!line.startsWith(TRANSITIONS)) continue;
            StringTokenizer st = new StringTokenizer(line);
            String transition = st.nextToken();
            int i = 0;
            while (st.hasMoreTokens() && i < this.transitions.length) {
                transition = st.nextToken().trim();
                this.transitions[i++] = Integer.parseInt(transition);
            }
        }
        reader.close();
    }

    private int parseLastInt(String line) {
        String lastInt = line.trim().substring(line.lastIndexOf(" "));
        return Integer.parseInt(lastInt.trim());
    }

    private int transition(int state, int symbol) {
        int i = state;
        while (i < this.transitions.length) {
            if (this.transitions[i] % this.vocabularySize == symbol) {
                return this.transitions[i] / this.vocabularySize;
            }
            ++i;
        }
        return -1;
    }

    public boolean accept(String inputString) {
        int start;
        int state = this.transition(0, 35);
        int leftEnd = inputString.length() - 1;
        int i = start = this.scanFromFront ? 0 : leftEnd;
        while (i >= 0 && i <= leftEnd) {
            char c = inputString.charAt(i);
            int symbol = c == 'n' || c == 'm' ? 78 : ("aeiouy".indexOf(c) != -1 ? 86 : (int)c);
            if ((state = this.transition(state, symbol)) == -1) {
                return false;
            }
            if (symbol == 86) {
                return true;
            }
            if (this.scanFromFront) {
                ++i;
                continue;
            }
            --i;
        }
        return false;
    }
}

