/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.alignment;

import edu.cmu.sphinx.alignment.TextTokenizer;
import edu.cmu.sphinx.alignment.UsEnglish;
import edu.cmu.sphinx.alignment.tokenizer.CharTokenizer;
import edu.cmu.sphinx.alignment.tokenizer.DecisionTree;
import edu.cmu.sphinx.alignment.tokenizer.FeatureSet;
import edu.cmu.sphinx.alignment.tokenizer.Item;
import edu.cmu.sphinx.alignment.tokenizer.NumberExpander;
import edu.cmu.sphinx.alignment.tokenizer.PrefixFSM;
import edu.cmu.sphinx.alignment.tokenizer.PronounceableFSM;
import edu.cmu.sphinx.alignment.tokenizer.Relation;
import edu.cmu.sphinx.alignment.tokenizer.SuffixFSM;
import edu.cmu.sphinx.alignment.tokenizer.Utterance;
import edu.cmu.sphinx.alignment.tokenizer.WordRelation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class USEnglishTokenizer
implements TextTokenizer {
    private static final Pattern alphabetPattern = Pattern.compile(UsEnglish.RX_ALPHABET);
    private static final Pattern commaIntPattern = Pattern.compile(UsEnglish.RX_COMMAINT);
    private static final Pattern digits2DashPattern = Pattern.compile("[0-9]+(-[0-9]+)(-[0-9]+)+");
    private static final Pattern digitsPattern = Pattern.compile(UsEnglish.RX_DIGITS);
    private static final Pattern digitsSlashDigitsPattern = Pattern.compile("[0-9]+/[0-9]+");
    private static final Pattern dottedAbbrevPattern = Pattern.compile(UsEnglish.RX_DOTTED_ABBREV);
    private static final Pattern doublePattern = Pattern.compile(UsEnglish.RX_DOUBLE);
    private static final Pattern drStPattern = Pattern.compile("([dD][Rr]|[Ss][Tt])");
    private static final Pattern fourDigitsPattern = Pattern.compile("[0-9][0-9][0-9][0-9]");
    private static final Pattern illionPattern;
    private static final Pattern numberTimePattern;
    private static final Pattern numessPattern;
    private static final Pattern ordinalPattern;
    private static final Pattern romanNumbersPattern;
    private static final Pattern sevenPhoneNumberPattern;
    private static final Pattern threeDigitsPattern;
    private static final Pattern usMoneyPattern;
    private static final String[] kingNames;
    private static final String[] kingTitles;
    private static final String[] sectionTypes;
    private static Map<String, String> kingSectionLikeMap;
    private static final String KING_NAMES = "kingNames";
    private static final String KING_TITLES = "kingTitles";
    private static final String SECTION_TYPES = "sectionTypes";
    private PronounceableFSM prefixFSM = null;
    private PronounceableFSM suffixFSM = null;
    private static final String[][] usStates;
    private static Map<String, String[]> usStatesMap;
    private WordRelation wordRelation;
    private Item tokenItem;
    private DecisionTree cart;

    static {
        Pattern.compile(".*[aeiouAEIOU].*");
        illionPattern = Pattern.compile(".*illion");
        numberTimePattern = Pattern.compile("((0[0-2])|(1[0-9])):([0-5][0-9])");
        numessPattern = Pattern.compile("[0-9]+s");
        ordinalPattern = Pattern.compile(UsEnglish.RX_ORDINAL_NUMBER);
        romanNumbersPattern = Pattern.compile("(II?I?|IV|VI?I?I?|IX|X[VIX]*)");
        sevenPhoneNumberPattern = Pattern.compile("[0-9][0-9][0-9]-[0-9][0-9][0-9][0-9]");
        threeDigitsPattern = Pattern.compile("[0-9][0-9][0-9]");
        usMoneyPattern = Pattern.compile("\\$[0-9,]+(\\.[0-9]+)?");
        kingNames = new String[]{"louis", "henry", "charles", "philip", "george", "edward", "pius", "william", "richard", "ptolemy", "john", "paul", "peter", "nicholas", "frederick", "james", "alfonso", "ivan", "napoleon", "leo", "gregory", "catherine", "alexandria", "pierre", "elizabeth", "mary", "elmo", "erasmus"};
        kingTitles = new String[]{"king", "queen", "pope", "duke", "tsar", "emperor", "shah", "caesar", "duchess", "tsarina", "empress", "baron", "baroness", "sultan", "count", "countess"};
        sectionTypes = new String[]{"section", "chapter", "part", "phrase", "verse", "scene", "act", "book", "volume", "chap", "war", "apollo", "trek", "fortran"};
        kingSectionLikeMap = new HashMap<String, String>();
        int i = 0;
        while (i < kingNames.length) {
            kingSectionLikeMap.put(kingNames[i], KING_NAMES);
            ++i;
        }
        i = 0;
        while (i < kingTitles.length) {
            kingSectionLikeMap.put(kingTitles[i], KING_TITLES);
            ++i;
        }
        i = 0;
        while (i < sectionTypes.length) {
            kingSectionLikeMap.put(sectionTypes[i], SECTION_TYPES);
            ++i;
        }
        usStates = new String[][]{{"AL", "ambiguous", "alabama"}, {"Al", "ambiguous", "alabama"}, {"Ala", "", "alabama"}, {"AK", "", "alaska"}, {"Ak", "", "alaska"}, {"AZ", "", "arizona"}, {"Az", "", "arizona"}, {"CA", "", "california"}, {"Ca", "", "california"}, {"Cal", "ambiguous", "california"}, {"Calif", "", "california"}, {"CO", "ambiguous", "colorado"}, {"Co", "ambiguous", "colorado"}, {"Colo", "", "colorado"}, {"DC", "", "d", "c"}, {"DE", "", "delaware"}, {"De", "ambiguous", "delaware"}, {"Del", "ambiguous", "delaware"}, {"FL", "", "florida"}, {"Fl", "ambiguous", "florida"}, {"Fla", "", "florida"}, {"GA", "", "georgia"}, {"Ga", "", "georgia"}, {"HI", "ambiguous", "hawaii"}, {"Hi", "ambiguous", "hawaii"}, {"IA", "", "iowa"}, {"Ia", "ambiguous", "iowa"}, {"IN", "ambiguous", "indiana"}, {"In", "ambiguous", "indiana"}, {"Ind", "ambiguous", "indiana"}, {"ID", "ambiguous", "idaho"}, {"IL", "ambiguous", "illinois"}, {"Il", "ambiguous", "illinois"}, {"ILL", "ambiguous", "illinois"}, {"KS", "", "kansas"}, {"Ks", "", "kansas"}, {"Kans", "", "kansas"}, {"KY", "ambiguous", "kentucky"}, {"Ky", "ambiguous", "kentucky"}, {"LA", "ambiguous", "louisiana"}, {"La", "ambiguous", "louisiana"}, {"Lou", "ambiguous", "louisiana"}, {"Lous", "ambiguous", "louisiana"}, {"MA", "ambiguous", "massachusetts"}, {"Mass", "ambiguous", "massachusetts"}, {"Ma", "ambiguous", "massachusetts"}, {"MD", "ambiguous", "maryland"}, {"Md", "ambiguous", "maryland"}, {"ME", "ambiguous", "maine"}, {"Me", "ambiguous", "maine"}, {"MI", "", "michigan"}, {"Mi", "ambiguous", "michigan"}, {"Mich", "ambiguous", "michigan"}, {"MN", "ambiguous", "minnestota"}, {"Minn", "ambiguous", "minnestota"}, {"MS", "ambiguous", "mississippi"}, {"Miss", "ambiguous", "mississippi"}, {"MT", "ambiguous", "montanna"}, {"Mt", "ambiguous", "montanna"}, {"MO", "ambiguous", "missouri"}, {"Mo", "ambiguous", "missouri"}, {"NC", "ambiguous", "north", "carolina"}, {"ND", "ambiguous", "north", "dakota"}, {"NE", "ambiguous", "nebraska"}, {"Ne", "ambiguous", "nebraska"}, {"Neb", "ambiguous", "nebraska"}, {"NH", "ambiguous", "new", "hampshire"}, {"NV", "", "nevada"}, {"Nev", "", "nevada"}, {"NY", "", "new", "york"}, {"OH", "ambiguous", "ohio"}, {"OK", "ambiguous", "oklahoma"}, {"Okla", "", "oklahoma"}, {"OR", "ambiguous", "oregon"}, {"Or", "ambiguous", "oregon"}, {"Ore", "ambiguous", "oregon"}, {"PA", "ambiguous", "pennsylvania"}, {"Pa", "ambiguous", "pennsylvania"}, {"Penn", "ambiguous", "pennsylvania"}, {"RI", "ambiguous", "rhode", "island"}, {"SC", "ambiguous", "south", "carlolina"}, {"SD", "ambiguous", "south", "dakota"}, {"TN", "ambiguous", "tennesee"}, {"Tn", "ambiguous", "tennesee"}, {"Tenn", "ambiguous", "tennesee"}, {"TX", "ambiguous", "texas"}, {"Tx", "ambiguous", "texas"}, {"Tex", "ambiguous", "texas"}, {"UT", "ambiguous", "utah"}, {"VA", "ambiguous", "virginia"}, {"WA", "ambiguous", "washington"}, {"Wa", "ambiguous", "washington"}, {"Wash", "ambiguous", "washington"}, {"WI", "ambiguous", "wisconsin"}, {"Wi", "ambiguous", "wisconsin"}, {"WV", "ambiguous", "west", "virginia"}, {"WY", "ambiguous", "wyoming"}, {"Wy", "ambiguous", "wyoming"}, {"Wyo", "", "wyoming"}, {"PR", "ambiguous", "puerto", "rico"}};
        usStatesMap = new HashMap<String, String[]>();
        i = 0;
        while (i < usStates.length) {
            usStatesMap.put(usStates[i][0], usStates[i]);
            ++i;
        }
    }

    public USEnglishTokenizer() {
        try {
            this.cart = new DecisionTree(this.getClass().getResource("nums_cart.txt"));
            this.prefixFSM = new PrefixFSM(this.getClass().getResource("prefix_fsm.txt"));
            this.suffixFSM = new SuffixFSM(this.getClass().getResource("suffix_fsm.txt"));
        }
        catch (IOException e) {
            throw new IllegalStateException("resources not found", e);
        }
    }

    public Item getTokenItem() {
        return this.tokenItem;
    }

    @Override
    public List<String> expand(String text) {
        String simplifiedText = this.simplifyChars(text);
        CharTokenizer tokenizer = new CharTokenizer();
        tokenizer.setWhitespaceSymbols(" \t\n\r");
        tokenizer.setSingleCharSymbols("");
        tokenizer.setPrepunctuationSymbols("\"'`({[");
        tokenizer.setPostpunctuationSymbols("\"'`.,:;!?(){}[]");
        tokenizer.setInputText(simplifiedText);
        Utterance utterance = new Utterance(tokenizer);
        Relation tokenRelation = utterance.getRelation("Token");
        if (tokenRelation == null) {
            throw new IllegalStateException("token relation does not exist");
        }
        this.wordRelation = WordRelation.createWordRelation(utterance, this);
        this.tokenItem = tokenRelation.getHead();
        while (this.tokenItem != null) {
            FeatureSet featureSet = this.tokenItem.getFeatures();
            String tokenVal = featureSet.getString("name");
            this.tokenToWords(tokenVal);
            this.tokenItem = this.tokenItem.getNext();
        }
        ArrayList<String> words = new ArrayList<String>();
        Item item = utterance.getRelation("Word").getHead();
        while (item != null) {
            if (!item.toString().isEmpty() && !item.toString().contains("#")) {
                words.add(item.toString());
            }
            item = item.getNext();
        }
        return words;
    }

    private String simplifyChars(String text) {
        text = text.replace('\u2019', '\'');
        text = text.replace('\u2018', '\'');
        text = text.replace('\u201d', '\"');
        text = text.replace('\u201c', '\"');
        text = text.replace('\u00bb', '\"');
        text = text.replace('\u00ab', '\"');
        text = text.replace('\u2013', '-');
        text = text.replace('\u2014', ' ');
        text = text.replace('\u2026', ' ');
        text = text.replace('\f', ' ');
        return text;
    }

    private boolean matchesPartPhoneNumber(String tokenVal) {
        String n_name = (String)this.tokenItem.findFeature("n.name");
        String n_n_name = (String)this.tokenItem.findFeature("n.n.name");
        String p_name = (String)this.tokenItem.findFeature("p.name");
        String p_p_name = (String)this.tokenItem.findFeature("p.p.name");
        boolean matches3DigitsP_name = USEnglishTokenizer.matches(threeDigitsPattern, p_name);
        return USEnglishTokenizer.matches(threeDigitsPattern, tokenVal) && (!USEnglishTokenizer.matches(digitsPattern, p_name) && USEnglishTokenizer.matches(threeDigitsPattern, n_name) && USEnglishTokenizer.matches(fourDigitsPattern, n_n_name) || USEnglishTokenizer.matches(sevenPhoneNumberPattern, n_name) || !USEnglishTokenizer.matches(digitsPattern, p_p_name) && matches3DigitsP_name && USEnglishTokenizer.matches(fourDigitsPattern, n_name)) || USEnglishTokenizer.matches(fourDigitsPattern, tokenVal) && !USEnglishTokenizer.matches(digitsPattern, n_name) && matches3DigitsP_name && USEnglishTokenizer.matches(threeDigitsPattern, p_p_name);
    }

    private void tokenToWords(String tokenVal) {
        FeatureSet tokenFeatures = this.tokenItem.getFeatures();
        String itemName = tokenFeatures.getString("name");
        int tokenLength = tokenVal.length();
        if (tokenFeatures.isPresent("phones")) {
            this.wordRelation.addWord(tokenVal);
        } else if (!(!tokenVal.equals("a") && !tokenVal.equals("A") || this.tokenItem.getNext() != null && tokenVal.equals(itemName) && ((String)this.tokenItem.findFeature("punc")).equals(""))) {
            this.wordRelation.addWord("_a");
        } else if (USEnglishTokenizer.matches(alphabetPattern, tokenVal)) {
            if (USEnglishTokenizer.matches(romanNumbersPattern, tokenVal)) {
                this.romanToWords(tokenVal);
            } else if (USEnglishTokenizer.matches(illionPattern, tokenVal) && USEnglishTokenizer.matches(usMoneyPattern, (String)this.tokenItem.findFeature("p.name"))) {
                this.wordRelation.addWord(tokenVal);
                this.wordRelation.addWord("dollars");
            } else if (USEnglishTokenizer.matches(drStPattern, tokenVal)) {
                this.drStToWords(tokenVal);
            } else if (tokenVal.equals("Mr")) {
                this.tokenItem.getFeatures().setString("punc", "");
                this.wordRelation.addWord("mister");
            } else if (tokenVal.equals("Mrs")) {
                this.tokenItem.getFeatures().setString("punc", "");
                this.wordRelation.addWord("missus");
            } else if (tokenLength == 1 && Character.isUpperCase(tokenVal.charAt(0)) && ((String)this.tokenItem.findFeature("n.whitespace")).equals(" ") && Character.isUpperCase(((String)this.tokenItem.findFeature("n.name")).charAt(0))) {
                tokenFeatures.setString("punc", "");
                String aaa = tokenVal.toLowerCase();
                if (aaa.equals("a")) {
                    this.wordRelation.addWord("_a");
                } else {
                    this.wordRelation.addWord(aaa);
                }
            } else if (!this.isStateName(tokenVal)) {
                if (tokenLength > 1 && !this.isPronounceable(tokenVal)) {
                    NumberExpander.expandLetters(tokenVal, this.wordRelation);
                } else {
                    this.wordRelation.addWord(tokenVal.toLowerCase());
                }
            }
        } else if (USEnglishTokenizer.matches(dottedAbbrevPattern, tokenVal)) {
            NumberExpander.expandLetters(tokenVal.replace(".", ""), this.wordRelation);
        } else if (USEnglishTokenizer.matches(commaIntPattern, tokenVal)) {
            NumberExpander.expandReal(tokenVal.replace(",", "").replace("'", ""), this.wordRelation);
        } else if (USEnglishTokenizer.matches(sevenPhoneNumberPattern, tokenVal)) {
            int dashIndex = tokenVal.indexOf(45);
            String aaa = tokenVal.substring(0, dashIndex);
            String bbb = tokenVal.substring(dashIndex + 1);
            NumberExpander.expandDigits(aaa, this.wordRelation);
            this.wordRelation.addBreak();
            NumberExpander.expandDigits(bbb, this.wordRelation);
        } else if (this.matchesPartPhoneNumber(tokenVal)) {
            String punctuation = (String)this.tokenItem.findFeature("punc");
            if (punctuation.equals("")) {
                this.tokenItem.getFeatures().setString("punc", ",");
            }
            NumberExpander.expandDigits(tokenVal, this.wordRelation);
            this.wordRelation.addBreak();
        } else if (USEnglishTokenizer.matches(numberTimePattern, tokenVal)) {
            int colonIndex = tokenVal.indexOf(58);
            String aaa = tokenVal.substring(0, colonIndex);
            String bbb = tokenVal.substring(colonIndex + 1);
            NumberExpander.expandNumber(aaa, this.wordRelation);
            if (!bbb.equals("00")) {
                NumberExpander.expandID(bbb, this.wordRelation);
            }
        } else if (USEnglishTokenizer.matches(digits2DashPattern, tokenVal)) {
            this.digitsDashToWords(tokenVal);
        } else if (USEnglishTokenizer.matches(digitsPattern, tokenVal)) {
            this.digitsToWords(tokenVal);
        } else if (tokenLength == 1 && Character.isUpperCase(tokenVal.charAt(0)) && ((String)this.tokenItem.findFeature("n.whitespace")).equals(" ") && Character.isUpperCase(((String)this.tokenItem.findFeature("n.name")).charAt(0))) {
            tokenFeatures.setString("punc", "");
            String aaa = tokenVal.toLowerCase();
            if (aaa.equals("a")) {
                this.wordRelation.addWord("_a");
            } else {
                this.wordRelation.addWord(aaa);
            }
        } else if (USEnglishTokenizer.matches(doublePattern, tokenVal)) {
            NumberExpander.expandReal(tokenVal, this.wordRelation);
        } else if (USEnglishTokenizer.matches(ordinalPattern, tokenVal)) {
            String aaa = tokenVal.substring(0, tokenLength - 2);
            NumberExpander.expandOrdinal(aaa, this.wordRelation);
        } else if (USEnglishTokenizer.matches(usMoneyPattern, tokenVal)) {
            this.usMoneyToWords(tokenVal);
        } else if (tokenLength > 0 && tokenVal.charAt(tokenLength - 1) == '%') {
            this.tokenToWords(tokenVal.substring(0, tokenLength - 1));
            this.wordRelation.addWord("percent");
        } else if (USEnglishTokenizer.matches(numessPattern, tokenVal)) {
            NumberExpander.expandNumess(tokenVal.substring(0, tokenLength - 1), this.wordRelation);
        } else if (USEnglishTokenizer.matches(digitsSlashDigitsPattern, tokenVal) && tokenVal.equals(itemName)) {
            this.digitsSlashDigitsToWords(tokenVal);
        } else if (tokenVal.indexOf(45) != -1) {
            this.dashToWords(tokenVal);
        } else if (tokenLength > 1 && !USEnglishTokenizer.matches(alphabetPattern, tokenVal)) {
            this.notJustAlphasToWords(tokenVal);
        } else if (tokenVal.equals("&")) {
            this.wordRelation.addWord("and");
        } else if (!tokenVal.equals("-")) {
            this.wordRelation.addWord(tokenVal.toLowerCase());
        }
    }

    private void digitsDashToWords(String tokenVal) {
        int tokenLength = tokenVal.length();
        int a = 0;
        int p = 0;
        while (p <= tokenLength) {
            if (p == tokenLength || tokenVal.charAt(p) == '-') {
                String aaa = tokenVal.substring(a, p);
                NumberExpander.expandDigits(aaa, this.wordRelation);
                this.wordRelation.addBreak();
                a = p + 1;
            }
            ++p;
        }
    }

    private void digitsToWords(String tokenVal) {
        FeatureSet featureSet = this.tokenItem.getFeatures();
        String nsw = "";
        if (featureSet.isPresent("nsw")) {
            nsw = featureSet.getString("nsw");
        }
        if (nsw.equals("nide")) {
            NumberExpander.expandID(tokenVal, this.wordRelation);
        } else {
            String rName = featureSet.getString("name");
            String digitsType = null;
            if (tokenVal.equals(rName)) {
                digitsType = (String)this.cart.interpret(this.tokenItem);
            } else {
                featureSet.setString("name", tokenVal);
                digitsType = (String)this.cart.interpret(this.tokenItem);
                featureSet.setString("name", rName);
            }
            if (digitsType.equals("ordinal")) {
                NumberExpander.expandOrdinal(tokenVal, this.wordRelation);
            } else if (digitsType.equals("digits")) {
                NumberExpander.expandDigits(tokenVal, this.wordRelation);
            } else if (digitsType.equals("year")) {
                NumberExpander.expandID(tokenVal, this.wordRelation);
            } else {
                NumberExpander.expandNumber(tokenVal, this.wordRelation);
            }
        }
    }

    private void romanToWords(String romanString) {
        String punctuation = (String)this.tokenItem.findFeature("p.punc");
        if (punctuation.equals("")) {
            String n = String.valueOf(NumberExpander.expandRoman(romanString));
            if (USEnglishTokenizer.kingLike(this.tokenItem)) {
                this.wordRelation.addWord("the");
                NumberExpander.expandOrdinal(n, this.wordRelation);
            } else if (USEnglishTokenizer.sectionLike(this.tokenItem)) {
                NumberExpander.expandNumber(n, this.wordRelation);
            } else {
                NumberExpander.expandLetters(romanString, this.wordRelation);
            }
        } else {
            NumberExpander.expandLetters(romanString, this.wordRelation);
        }
    }

    private static boolean inKingSectionLikeMap(String key, String value) {
        if (kingSectionLikeMap.containsKey(key)) {
            return kingSectionLikeMap.get(key).equals(value);
        }
        return false;
    }

    public static boolean kingLike(Item tokenItem) {
        String kingName = ((String)tokenItem.findFeature("p.name")).toLowerCase();
        if (USEnglishTokenizer.inKingSectionLikeMap(kingName, KING_NAMES)) {
            return true;
        }
        String kingTitle = ((String)tokenItem.findFeature("p.p.name")).toLowerCase();
        return USEnglishTokenizer.inKingSectionLikeMap(kingTitle, KING_TITLES);
    }

    public static boolean sectionLike(Item tokenItem) {
        String sectionType = ((String)tokenItem.findFeature("p.name")).toLowerCase();
        return USEnglishTokenizer.inKingSectionLikeMap(sectionType, SECTION_TYPES);
    }

    private void drStToWords(String drStString) {
        String street = null;
        String saint = null;
        char c0 = drStString.charAt(0);
        if (c0 == 's' || c0 == 'S') {
            street = "street";
            saint = "saint";
        } else {
            street = "drive";
            saint = "doctor";
        }
        FeatureSet featureSet = this.tokenItem.getFeatures();
        String punctuation = featureSet.getString("punc");
        String featPunctuation = (String)this.tokenItem.findFeature("punc");
        if (this.tokenItem.getNext() == null || punctuation.indexOf(44) != -1) {
            this.wordRelation.addWord(street);
        } else if (featPunctuation.equals(",")) {
            this.wordRelation.addWord(saint);
        } else {
            String pName = (String)this.tokenItem.findFeature("p.name");
            String nName = (String)this.tokenItem.findFeature("n.name");
            char p0 = pName.charAt(0);
            char n0 = nName.charAt(0);
            if (Character.isUpperCase(p0) && Character.isLowerCase(n0)) {
                this.wordRelation.addWord(street);
            } else if (Character.isDigit(p0) && Character.isLowerCase(n0)) {
                this.wordRelation.addWord(street);
            } else if (Character.isLowerCase(p0) && Character.isUpperCase(n0)) {
                this.wordRelation.addWord(saint);
            } else {
                String whitespace = (String)this.tokenItem.findFeature("n.whitespace");
                if (whitespace.equals(" ")) {
                    this.wordRelation.addWord(saint);
                } else {
                    this.wordRelation.addWord(street);
                }
            }
        }
        if (punctuation != null && punctuation.equals(".")) {
            featureSet.setString("punc", "");
        }
    }

    private void usMoneyToWords(String tokenVal) {
        int dotIndex = tokenVal.indexOf(46);
        if (USEnglishTokenizer.matches(illionPattern, (String)this.tokenItem.findFeature("n.name"))) {
            NumberExpander.expandReal(tokenVal.substring(1), this.wordRelation);
        } else if (dotIndex == -1) {
            String aaa = tokenVal.substring(1);
            this.tokenToWords(aaa);
            if (aaa.equals("1")) {
                this.wordRelation.addWord("dollar");
            } else {
                this.wordRelation.addWord("dollars");
            }
        } else if (dotIndex == tokenVal.length() - 1 || tokenVal.length() - dotIndex > 3) {
            NumberExpander.expandReal(tokenVal.substring(1), this.wordRelation);
            this.wordRelation.addWord("dollars");
        } else {
            String aaa = tokenVal.substring(1, dotIndex).replace(",", "");
            String bbb = tokenVal.substring(dotIndex + 1);
            NumberExpander.expandNumber(aaa, this.wordRelation);
            if (aaa.equals("1")) {
                this.wordRelation.addWord("dollar");
            } else {
                this.wordRelation.addWord("dollars");
            }
            if (!bbb.equals("00")) {
                NumberExpander.expandNumber(bbb, this.wordRelation);
                if (bbb.equals("01")) {
                    this.wordRelation.addWord("cent");
                } else {
                    this.wordRelation.addWord("cents");
                }
            }
        }
    }

    private void digitsSlashDigitsToWords(String tokenVal) {
        int index = tokenVal.indexOf(47);
        String aaa = tokenVal.substring(0, index);
        String bbb = tokenVal.substring(index + 1);
        if (USEnglishTokenizer.matches(digitsPattern, (String)this.tokenItem.findFeature("p.name")) && this.tokenItem.getPrevious() != null) {
            this.wordRelation.addWord("and");
        }
        if (aaa.equals("1") && bbb.equals("2")) {
            this.wordRelation.addWord("a");
            this.wordRelation.addWord("half");
        } else {
            int a = Integer.parseInt(aaa);
            if (a < Integer.parseInt(bbb)) {
                NumberExpander.expandNumber(aaa, this.wordRelation);
                NumberExpander.expandOrdinal(bbb, this.wordRelation);
                if (a > 1) {
                    this.wordRelation.addWord("'s");
                }
            } else {
                NumberExpander.expandNumber(aaa, this.wordRelation);
                this.wordRelation.addWord("slash");
                NumberExpander.expandNumber(bbb, this.wordRelation);
            }
        }
    }

    private void dashToWords(String tokenVal) {
        int index = tokenVal.indexOf(45);
        String aaa = tokenVal.substring(0, index);
        String bbb = tokenVal.substring(index + 1, tokenVal.length());
        if (USEnglishTokenizer.matches(digitsPattern, aaa) && USEnglishTokenizer.matches(digitsPattern, bbb)) {
            FeatureSet featureSet = this.tokenItem.getFeatures();
            featureSet.setString("name", aaa);
            this.tokenToWords(aaa);
            this.wordRelation.addWord("to");
            featureSet.setString("name", bbb);
            this.tokenToWords(bbb);
            featureSet.setString("name", "");
        } else {
            this.tokenToWords(aaa);
            this.tokenToWords(bbb);
        }
    }

    private void notJustAlphasToWords(String tokenVal) {
        int index = 0;
        int tokenLength = tokenVal.length();
        while (index < tokenLength - 1) {
            if (USEnglishTokenizer.isTextSplitable(tokenVal, index)) break;
            ++index;
        }
        if (index == tokenLength - 1) {
            this.wordRelation.addWord(tokenVal.toLowerCase());
            return;
        }
        String aaa = tokenVal.substring(0, index + 1);
        String bbb = tokenVal.substring(index + 1, tokenLength);
        FeatureSet featureSet = this.tokenItem.getFeatures();
        featureSet.setString("nsw", "nide");
        this.tokenToWords(aaa);
        this.tokenToWords(bbb);
    }

    public boolean isPronounceable(String word) {
        String lcWord = word.toLowerCase();
        return this.prefixFSM.accept(lcWord) && this.suffixFSM.accept(lcWord);
    }

    private boolean isStateName(String tokenVal) {
        String[] state = usStatesMap.get(tokenVal);
        if (state != null) {
            boolean expandState = false;
            if (state[1].equals("ambiguous")) {
                boolean nextIsGood;
                String previous = (String)this.tokenItem.findFeature("p.name");
                String next = (String)this.tokenItem.findFeature("n.name");
                int nextLength = next.length();
                FeatureSet featureSet = this.tokenItem.getFeatures();
                boolean previousIsCity = Character.isUpperCase(previous.charAt(0)) && previous.length() > 2 && USEnglishTokenizer.matches(alphabetPattern, previous) && this.tokenItem.findFeature("p.punc").equals(",");
                boolean bl = nextIsGood = Character.isLowerCase(next.charAt(0)) || this.tokenItem.getNext() == null || featureSet.getString("punc").equals(".") || (nextLength == 5 || nextLength == 10) && USEnglishTokenizer.matches(digitsPattern, next);
                expandState = previousIsCity && nextIsGood;
            } else {
                expandState = true;
            }
            if (expandState) {
                int j = 2;
                while (j < state.length) {
                    if (state[j] != null) {
                        this.wordRelation.addWord(state[j]);
                    }
                    ++j;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean matches(Pattern pattern, String input) {
        Matcher m = pattern.matcher(input);
        return m.matches();
    }

    private static boolean isTextSplitable(String text, int index) {
        char c0 = text.charAt(index);
        char c1 = text.charAt(index + 1);
        if (Character.isLetter(c0) && Character.isLetter(c1)) {
            return false;
        }
        if (Character.isDigit(c0) && Character.isDigit(c1)) {
            return false;
        }
        if (c0 == '\'' || Character.isLetter(c1)) {
            return false;
        }
        return c1 != '\'' && !Character.isLetter(c0);
    }
}

