/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.alignment;

import edu.cmu.sphinx.util.Range;
import edu.cmu.sphinx.util.Utilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.TreeSet;

public class LongTextAligner {
    private final int tupleSize;
    private final List<String> reftup;
    private final HashMap<String, ArrayList<Integer>> tupleIndex;
    private List<String> refWords;

    public LongTextAligner(List<String> words, int tupleSize) {
        assert (words != null);
        assert (tupleSize > 0);
        this.tupleSize = tupleSize;
        this.refWords = words;
        int offset = 0;
        this.reftup = this.getTuples(words);
        this.tupleIndex = new HashMap();
        for (String tuple : this.reftup) {
            ArrayList<Integer> indexes = this.tupleIndex.get(tuple);
            if (indexes == null) {
                indexes = new ArrayList();
                this.tupleIndex.put(tuple, indexes);
            }
            indexes.add(offset++);
        }
    }

    public int[] align(List<String> query) {
        return this.align(query, new Range(0, this.refWords.size()));
    }

    public int[] align(List<String> words, Range range) {
        if (range.upperEndpoint() - range.lowerEndpoint() < this.tupleSize || words.size() < this.tupleSize) {
            return LongTextAligner.alignTextSimple(this.refWords.subList(range.lowerEndpoint(), range.upperEndpoint()), words, range.lowerEndpoint());
        }
        int[] result = new int[words.size()];
        Arrays.fill(result, -1);
        int lastIndex = 0;
        for (Alignment.Node node : new Alignment(this.getTuples(words), range).getIndices()) {
            lastIndex = Math.max(lastIndex, node.getQueryIndex());
            while (lastIndex < node.getQueryIndex() + this.tupleSize) {
                result[lastIndex] = node.getDatabaseIndex() + lastIndex - node.getQueryIndex();
                ++lastIndex;
            }
        }
        return result;
    }

    private List<String> getTuples(List<String> words) {
        ArrayList<String> result = new ArrayList<String>();
        LinkedList<String> tuple = new LinkedList<String>();
        Iterator<String> it = words.iterator();
        int i = 0;
        while (i < this.tupleSize - 1) {
            tuple.add(it.next());
            ++i;
        }
        while (it.hasNext()) {
            tuple.addLast(it.next());
            result.add(Utilities.join(tuple));
            tuple.removeFirst();
        }
        return result;
    }

    static int[] alignTextSimple(List<String> database, List<String> query, int offset) {
        int n = database.size() + 1;
        int m = query.size() + 1;
        int[][] f = new int[n][m];
        f[0][0] = 0;
        int i = 1;
        while (i < n) {
            f[i][0] = i;
            ++i;
        }
        int j = 1;
        while (j < m) {
            f[0][j] = j;
            ++j;
        }
        i = 1;
        while (i < n) {
            int j2 = 1;
            while (j2 < m) {
                String queryWord;
                int match = f[i - 1][j2 - 1];
                String refWord = database.get(i - 1);
                if (!refWord.equals(queryWord = query.get(j2 - 1))) {
                    ++match;
                }
                int insert = f[i][j2 - 1] + 1;
                int delete = f[i - 1][j2] + 1;
                f[i][j2] = Math.min(match, Math.min(insert, delete));
                ++j2;
            }
            ++i;
        }
        --n;
        int[] alignment = new int[--m];
        Arrays.fill(alignment, -1);
        while (m > 0) {
            if (n == 0) {
                --m;
                continue;
            }
            String refWord = database.get(n - 1);
            String queryWord = query.get(m - 1);
            if (f[n - 1][m - 1] <= f[n - 1][m - 1] && f[n - 1][m - 1] <= f[n][m - 1] && refWord.equals(queryWord)) {
                alignment[--m] = --n + offset;
                continue;
            }
            if (f[n - 1][m] < f[n][m - 1]) {
                --n;
                continue;
            }
            --m;
        }
        return alignment;
    }

    private final class Alignment {
        private final List<Integer> shifts;
        private final List<String> query;
        private final List<Integer> indices;
        private final List<Node> alignment;

        public Alignment(List<String> query, Range range) {
            this.query = query;
            this.indices = new ArrayList<Integer>();
            TreeSet<Integer> shiftSet = new TreeSet<Integer>();
            int i = 0;
            while (i < query.size()) {
                if (LongTextAligner.this.tupleIndex.containsKey(query.get(i))) {
                    this.indices.add(i);
                    for (Integer shift : (ArrayList)LongTextAligner.this.tupleIndex.get(query.get(i))) {
                        if (!range.contains(shift)) continue;
                        shiftSet.add(shift);
                    }
                }
                ++i;
            }
            this.shifts = new ArrayList<Integer>(shiftSet);
            final HashMap<Node, Integer> cost = new HashMap<Node, Integer>();
            PriorityQueue<Node> openSet = new PriorityQueue<Node>(1, new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    return ((Integer)cost.get(o1)).compareTo((Integer)cost.get(o2));
                }
            });
            HashSet<Node> closedSet = new HashSet<Node>();
            HashMap<Node, Node> parents = new HashMap<Node, Node>();
            Node startNode = new Node(0, 0);
            cost.put(startNode, 0);
            openSet.add(startNode);
            while (!openSet.isEmpty()) {
                Node q = openSet.poll();
                if (closedSet.contains(q)) continue;
                if (q.isTarget()) {
                    ArrayList<Node> backtrace = new ArrayList<Node>();
                    while (parents.containsKey(q)) {
                        if (!q.isBoundary() && q.hasMatch()) {
                            backtrace.add(q);
                        }
                        q = (Node)parents.get(q);
                    }
                    this.alignment = new ArrayList<Node>(backtrace);
                    Collections.reverse(this.alignment);
                    return;
                }
                closedSet.add(q);
                for (Node nb : q.adjacent()) {
                    int newScore;
                    if (closedSet.contains(nb)) continue;
                    int l = Math.abs(this.indices.size() - this.shifts.size() - q.queryIndex + q.databaseIndex) - Math.abs(this.indices.size() - this.shifts.size() - nb.queryIndex + nb.databaseIndex);
                    Integer oldScore = (Integer)cost.get(nb);
                    Integer qScore = (Integer)cost.get(q);
                    if (oldScore == null) {
                        oldScore = Integer.MAX_VALUE;
                    }
                    if (qScore == null) {
                        qScore = Integer.MAX_VALUE;
                    }
                    if ((newScore = qScore + nb.getValue() - l) >= oldScore) continue;
                    cost.put(nb, newScore);
                    openSet.add(nb);
                    parents.put(nb, q);
                }
            }
            this.alignment = Collections.emptyList();
        }

        public List<Node> getIndices() {
            return this.alignment;
        }

        public final class Node {
            private final int databaseIndex;
            private final int queryIndex;

            private Node(int row, int column) {
                this.databaseIndex = column;
                this.queryIndex = row;
            }

            public int getDatabaseIndex() {
                return (Integer)Alignment.this.shifts.get(this.databaseIndex - 1);
            }

            public int getQueryIndex() {
                return (Integer)Alignment.this.indices.get(this.queryIndex - 1);
            }

            public String getQueryWord() {
                if (this.queryIndex > 0) {
                    return (String)Alignment.this.query.get(this.getQueryIndex());
                }
                return null;
            }

            public String getDatabaseWord() {
                if (this.databaseIndex > 0) {
                    return (String)LongTextAligner.this.reftup.get(this.getDatabaseIndex());
                }
                return null;
            }

            public int getValue() {
                if (this.isBoundary()) {
                    return Math.max(this.queryIndex, this.databaseIndex);
                }
                return this.hasMatch() ? 0 : 1;
            }

            public boolean hasMatch() {
                return this.getQueryWord().equals(this.getDatabaseWord());
            }

            public boolean isBoundary() {
                return this.queryIndex == 0 || this.databaseIndex == 0;
            }

            public boolean isTarget() {
                return this.queryIndex == Alignment.this.indices.size() && this.databaseIndex == Alignment.this.shifts.size();
            }

            public List<Node> adjacent() {
                ArrayList<Node> result = new ArrayList<Node>(3);
                if (this.queryIndex < Alignment.this.indices.size() && this.databaseIndex < Alignment.this.shifts.size()) {
                    result.add(new Node(this.queryIndex + 1, this.databaseIndex + 1));
                }
                if (this.databaseIndex < Alignment.this.shifts.size()) {
                    result.add(new Node(this.queryIndex, this.databaseIndex + 1));
                }
                if (this.queryIndex < Alignment.this.indices.size()) {
                    result.add(new Node(this.queryIndex + 1, this.databaseIndex));
                }
                return result;
            }

            public boolean equals(Object object) {
                if (!(object instanceof Node)) {
                    return false;
                }
                Node other = (Node)object;
                return this.queryIndex == other.queryIndex && this.databaseIndex == other.databaseIndex;
            }

            public int hashCode() {
                return 31 * (31 * this.queryIndex + this.databaseIndex);
            }

            public String toString() {
                return String.format("[%d %d]", this.queryIndex, this.databaseIndex);
            }
        }
    }
}

