#!dds_perl

my $itc_auth    = `dds_cfgutil itcauthentication`;
my $config_file = `dds_cfgutil appconfig_file`;
chomp($itc_auth);
chomp($config_file);

print STDERR "%dds_set%itc_auth=$itc_auth\n";
print STDERR "%dds_set%config_file=$config_file\n";
print STDERR "%dds_set%total_size=0\n";
print STDERR "%dds_set%total_count=0\n";
print STDERR "%dds_set%start_time=" . time() . "\n";
print STDERR "%dds_set%skip_count=0\n";

eval {
	my $target_directory = q|%target_directory%|;
	if ( substr ($target_directory, 0, 22) eq "%dds_default_directory") {
		die "Configuration error: no default directory has been set\n";
	}

	if ( !-e $target_directory ) {
		my $fullpath = "";
		### skip next component (i.e. server name) if UNC pathname
		my $skipNextComponent = ( $target_directory =~ m|^//| );

		foreach my $path ( split( "/", $target_directory ) ) {
			$fullpath .= "$path/";
			next if ( "$path" eq "" );    ### skip any "empty" path component

			if ($skipNextComponent) {
				$skipNextComponent = 0;
				next;
			}

			if ( !-e $fullpath ) {
				mkdir $fullpath or die "Cannot create $fullpath: $!\n";
			}
		}
	}
};

if ($@) {
	print STDERR "ERROR: $@\n";
}

exit 0;
