#!dds_perl

${^WIDE_SYSTEM_CALLS}=1;
select STDOUT ; $| = 1;

use Encode;

my $itc_auth = q|%itc_auth%|;
my $config_file = q|%config_file%|;

if ( substr($itc_auth,0,9) eq "%itc_auth" )
{
    $itc_auth = `dds_cfgutil itcauthentication`;
    chomp ($itc_auth);
}

if ( substr($config_file,0,12) eq "%config_file" )
{
    $config_file = `dds_cfgutil appconfig_file`;
    chomp ($config_file);
}

my %config;

eval
{
    if (lc($itc_auth) ne "local")
    {
        require SOAP::Lite;
        import SOAP::Lite;

        load_config($config_file, \%config);
    }

    my $TOTAL_SIZE = 0;
    my $TOTAL_COUNT = 0;
    my $SKIP_COUNT = 0;

    while ( $LINE = <STDIN> )
    {
        if (lc($itc_auth) eq "local")
        {
            print STDOUT "ok\n";
            next;
        }

        # "<file-name>"   <disposition>   <type>   <size>   <date>   <time>
        #
        $LINE =~ m/\"(.+)?\"\s+(\S+)?\s+(\S+)?\s+(\S+)?/;
        $FILENAME = $1;
        $DISP = $2;
        $TYPE = $3;
        $SIZE = $4;
        $DATE = $5;
        $TIME = $6;

        my $session_id = "%session_id%";
        my $source_path = SOAP::Data->value(Encode::decode_utf8($FILENAME))->type('string');
        my $completion = $DISP;

        my $urls = $config{ITC_END_FILE_URLS};

        foreach my $url (split (",", $urls))
        {
            eval
            {
                my $useUri = (defined $config{ITC_END_FILE_URI} ? 1: 0);
                my $uri = ($useUri ? $config{ITC_END_FILE_URI} : "InteractiveTransferService" );

                print STDERR "DEBUG: Calling SOAP server: $url $uri\n";
                my $soapCall = SOAP::Lite -> proxy($url) -> uri($uri) -> on_action(sub{sprintf '%s/%s', @_ });

                my $soapResult;
                if( $useUri )
                {
                    $soapResult = $soapCall -> ITC_End_File
                      (SOAP::Data->type(string => $session_id) ->name("session_id") ->uri(""),
                                                  $source_path ->name("source_path")->uri(""),
                       SOAP::Data->type(string => $completion) ->name("completion") ->uri(""));
                }
                else
                {
                    $soapResult = $soapCall -> ITC_End_File($session_id,
                                                            $source_path,
                                                            $completion);
                }

                if ($soapResult->fault)
                {
                    my $faultstring = $soapResult->faultstring;
                    $faultstring =~ s/\n/\\n/g;
                    die $soapResult->faultcode ." $faultstring\n";
                }
                last;
            };
            if ($@)
            {
                print STDERR "ERROR: SOAP server: $url $@\n";
                next;
            }
        }

        if ($completion ne "error")
        {
            $TOTAL_SIZE += $SIZE;
            $TOTAL_COUNT ++;
        }
        
        if ($completion eq "skipped")
        {
            $SKIP_COUNT ++;
        }

        print STDERR "%dds_set%total_size=$TOTAL_SIZE\n";
        print STDERR "%dds_set%total_count=$TOTAL_COUNT\n";
        print STDERR "%dds_set%skip_count=$SKIP_COUNT\n";

        print STDOUT "ok\n";
    }

};
if ($@)
{
    print STDERR "ERROR: Internal error: $@\n";
}
exit 0;

sub load_config($%)
{
    open (FH, $_[0]) or die "Cannot open config file $_[0]: $!\n";
    my $config = $_[1];
    while (my $line=<FH>)
    {
        chomp ($line);
        #if (! $line =~ m/^#/)
        #{
        my ($key,$value) = split("=", $line, 2);
        $config->{$key} = $value;
        #}
    }
}
