#!dds_perl

${^WIDE_SYSTEM_CALLS}=1;
select STDOUT ; $| = 1;

use Encode;

my $itc_auth = q|%itc_auth%|;
my $config_file = q|%config_file%|;

if ( substr($itc_auth,0,9) eq "%itc_auth" )
{
    $itc_auth = `dds_cfgutil itcauthentication`;
    chomp ($itc_auth);
}

if ( substr($config_file,0,12) eq "%config_file" )
{
    $config_file = `dds_cfgutil appconfig_file`;
    chomp ($config_file);
}

my %config;

eval
{
    if (lc($itc_auth) ne "local")
    {
        require SOAP::Lite;
        import SOAP::Lite;

        load_config($config_file, \%config);
    }

    while ( $LINE = <STDIN> )
    {
        if (lc($itc_auth) eq "local")
        {
            print STDOUT "ok\n";
            next;
        }

        # "<file-name>"   <disposition>   <type>   <size>   <date>   <time>
        #
        $LINE =~ m/\"(.+)?\"\s+(\S+)?\s+(\S+)?\s+(\S+)?/;
        $FILENAME = $1;
        $DISP = $2;
        $TYPE = $3;
        $FILESIZE = $4;
        $DATE = $5;
        $TIME = $6;

        my $session_id = "%session_id%";
        my $direction = "RECEIVE";
        my $source_path = SOAP::Data->value(Encode::decode_utf8($FILENAME))->type('string');
        my $size = SOAP::Data->value($FILESIZE)->type('long');

        my $urls = $config{ITC_BEGIN_FILE_URLS};
        my $output = "ok";

        foreach my $url (split (",", $urls))
        {
            $output = "skip";
            eval
            {
                my $useUri = (defined $config{ITC_BEGIN_FILE_URI} ? 1: 0);
                my $uri = ($useUri ? $config{ITC_BEGIN_FILE_URI} : "InteractiveTransferService" );

                print STDERR "DEBUG: Calling SOAP server: $url $uri\n";
                my $soapCall = SOAP::Lite -> proxy($url) -> uri($uri) -> on_action(sub{sprintf '%s/%s', @_ });

                my $soapResult;
                if( $useUri )
                {
                    $soapResult = $soapCall -> ITC_Begin_File
                      (SOAP::Data->type(string => $session_id) ->name("session_id") ->uri(""),
                       SOAP::Data->type(string => $direction)  ->name("direction")  ->uri(""),
                                                  $source_path ->name("source_path")->uri(""),
                                                  $size        ->name("file_size") ->uri(""));
                }
                else
                {
                    $soapResult = $soapCall -> ITC_Begin_File($session_id,
                                                             $direction,
                                                             $source_path,
                                                             $size);
                }

                if ($soapResult->fault)
                {
                    my $faultstring = $soapResult->faultstring;
                    $faultstring =~ s/\n/\\n/g;
                    die $soapResult->faultcode ." $faultstring\n";
                }

                my $allow = $soapResult->result();
                if (lc($allow) eq "y" )
                {
                    $output = "ok";
                }
                last;
            };
            if ($@)
            {
                print STDERR "ERROR: SOAP server: $url $@\n";
                next;
            }
        }
        print STDERR "DEBUG: $output $FILENAME\n";
        print STDOUT "$output\n";
        if ($output ne "ok")
        {
            print STDERR "WARNING: Denied by policy: $FILENAME\n";
        }
    }
};
if ($@)
{
    print STDERR "ERROR: Internal error: $@\n";
}
exit 0;

sub load_config($%)
{
    open (FH, $_[0]) or die "Cannot open config file $_[0]: $!\n";
    my $config = $_[1];
    while (my $line=<FH>)
    {
        chomp ($line);
        #if (! $line =~ m/^#/)
        #{
        my ($key,$value) = split("=", $line, 2);
        $config->{$key} = $value;
        #}
    }
}
