#!dds_perl

${^WIDE_SYSTEM_CALLS}=1;
select STDOUT ; $| = 1;

use Encode;

my $itc_auth = q|%itc_auth%|;
my $config_file = q|%config_file%|;

if ( substr($itc_auth,0,9) eq "%itc_auth" )
{
    $itc_auth = `dds_cfgutil itcauthentication`;
    chomp ($itc_auth);
}

if ( substr($config_file,0,12) eq "%config_file" )
{
    $config_file = `dds_cfgutil appconfig_file`;
    chomp ($config_file);
}

if (lc($itc_auth) eq "local")
{
    exit 0;
}

my %config;

eval
{
    require SOAP::Lite;
    import SOAP::Lite;

    load_config($config_file, \%config);

    my $TOTAL_SIZE=q|%total_size%|;
    my $TOTAL_COUNT=q|%total_count%|;
    my $SKIP_COUNT=q|%skip_count%|;
    my $START_TIME=q|%start_time%|;
    my $REMOTE_HOST=q|%tgt_host%|;

    if ( substr($TOTAL_SIZE,0,11) eq "%total_size" )
    {
        # For some reason the prepackage did not run, so we did not
        # get a value for total size, default it now to 0
        $TOTAL_SIZE = 0;
    }

    if ( substr($TOTAL_COUNT,0,12) eq "%total_count" )
    {
        $TOTAL_COUNT = 0;
    }

    if ( substr($SKIP_COUNT,0,11) eq "%skip_count" )
    {
        $SKIP_COUNT = 0;
    }

    if ( substr($START_TIME,0,11) eq "%start_time" )
    {
        $START_TIME = time();
    }
    my $DURATION = time() - $START_TIME;

    print STDERR "DEBUG: Total size is: $TOTAL_SIZE\n";
    print STDERR "DEBUG: Total count is: $TOTAL_COUNT\n";
    print STDERR "DEBUG: Skip count is: $SKIP_COUNT\n";
    print STDERR "DEBUG: Total run time is: $DURATION\n";

    my $session_id = "%session_id%";
    my $remote_host = Encode::decode_utf8($REMOTE_HOST);
    my $size = SOAP::Data->value($TOTAL_SIZE)->type('long');
    my $count = SOAP::Data->value($TOTAL_COUNT)->type('long');
    my $time = SOAP::Data->value($DURATION)->type('long');
    my $skip = SOAP::Data->value($SKIP_COUNT)->type('long');

    my $urls = $config{ITC_DISCONNECT_URLS};

    foreach my $url (split (",", $urls))
    {
        eval
        {
            my $useUri = (defined $config{ITC_DISCONNECT_URI} ? 1: 0);
            my $uri = ($useUri ? $config{ITC_DISCONNECT_URI} : "InteractiveTransferService" );

            print STDERR "DEBUG: Calling SOAP server: $url $uri\n";
            my $soapCall = SOAP::Lite -> proxy($url) -> uri($uri) -> on_action(sub{sprintf '%s/%s', @_ });

            my $soapResult;
            if ( $useUri )
            {
                $soapResult = $soapCall -> ITC_Disconnect
                  (SOAP::Data->type(string => $session_id) ->name("session_id")             ->uri(""),
                   SOAP::Data->type(string => remote_host) ->name("remote_host")            ->uri(""),
                                              $count       ->name("transfer_number")        ->uri(""),
                                              $size        ->name("transfer_size")          ->uri(""),
                                              $time        ->name("transfer_time")          ->uri(""),
                                              $skip        ->name("transfer_skip")          ->uri(""));
            }
            else
            {
                $soapResult = $soapCall -> ITC_Disconnect($session_id,
                                                          $REMOTE_HOST,
                                                          $count,
                                                          $size,
                                                          $time,
                                                          $skip);
            }

            if ($soapResult->fault)
            {
                my $faultstring = $soapResult->faultstring;
                $faultstring =~ s/\n/\\n/g;
                die $soapResult->faultcode ." $faultstring\n";
            }

            last;
        };
        if ($@)
        {
            print STDERR "ERROR: SOAP server: $url $@\n";
            next;
        }
    }
    ;
};
if ($@)
{
    print STDERR "ERROR: Internal error: $@\n";
}

exit 0;

sub load_config($%)
{
    open (FH, $_[0]) or die "Cannot open config file $_[0]: $!\n";
    my $config = $_[1];
    while (my $line=<FH>)
    {
        chomp ($line);
        #if (! $line =~ m/^#/)
        #{
        my ($key,$value) = split("=", $line, 2);
        $config->{$key} = $value;
        #}
    }
}
