<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="html" indent="yes"/>

    <xsl:template match="/verifier">
        <html>
            <head>
                <title>Thou shall not send…</title>
                <style type="text/css">
                    body {
                        font-family: Lucida Grande, Arial, Verdana;
                        padding: 20px;
                        font-size: 12px;
                    }
                    .wrapper {
                        background-color: rgb(220, 220, 220);
                        padding: 20px;
                    }
                    h1 {
                        font-size: 18px;
                        text-align: center;
                    }
                    li {
                        margin-bottom: 8px;
                    }</style>
            </head>
            <body>
                <div class="wrapper">
                    <h4 style="text-align: right"> iTunes Store — Video Workflow Engineering</h4>

                    <h1>Leghorn Blacklist (environment: <xsl:value-of select="@environment"
                        />)</h1>
                    <p>The following container aspects are blacklisted via Leghorn conformance. This
                        list is updated regularly. Please contact the <a
                            href="mailto:jingle-video-workflow@groups.apple.com">Video Workflow
                            Team</a> in case you have any questions.</p>
                    <ul>
                        <xsl:for-each select="./containers/container">
                            <li class="container-description">
                                <span>
                                    <b>Container Type: <xsl:value-of select="@description"/></b>
                                </span>
                                <ul>
                                    <xsl:apply-templates select="conformance"/>
                                </ul>
                            </li>
                        </xsl:for-each>
                    </ul>
                    <h1>APPLE CONFIDENTIAL</h1>
                </div>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="conformance">
        <li class="conformance">
            <df class="name">[<b>Code <xsl:value-of select="blacklist/code"/></b>] <xsl:value-of
                    select="@name"/></df>
            <dd class="explaination">
                <xsl:value-of select="blacklist/explanation"/>
            </dd>
        </li>
    </xsl:template>
</xsl:stylesheet>
