/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.mediatoolkit;

import com.apple.transporter.toolregistry.api.ToolRegistry;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class MediaToolkitBundleActivator
implements BundleActivator {
    BundleContext bundleContext = null;
    ServiceListener toolRegistryListener = null;

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        this.registerTools();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (null != this.toolRegistryListener) {
            bundleContext.removeServiceListener(this.toolRegistryListener);
        }
    }

    private void registerTools() throws InvalidSyntaxException {
        ServiceReference svcRef = this.bundleContext.getServiceReference(ToolRegistry.class.getName());
        if (null != svcRef) {
            this.registerTools(svcRef);
        } else {
            this.toolRegistryListener = new ServiceListener(){

                public void serviceChanged(ServiceEvent event) {
                    switch (event.getType()) {
                        case 1: {
                            MediaToolkitBundleActivator.this.registerTools(event.getServiceReference());
                            break;
                        }
                    }
                }
            };
            String filter = "(objectClass=" + ToolRegistry.class.getName() + ")";
            this.bundleContext.addServiceListener(this.toolRegistryListener, filter);
        }
    }

    private void registerTools(ServiceReference svcRef) {
        ToolRegistry registry = (ToolRegistry)this.bundleContext.getService(svcRef);
        if (null != registry) {
            registry.registerToolsInBundleFromProperties(this.bundleContext.getBundle(), "mediatoolkit.tool.properties");
            this.bundleContext.ungetService(svcRef);
        }
    }
}

