/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.util;

import java.io.IOException;
import java.io.StringReader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlLineNumber;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlTokenSource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlBeansHelper {
    public static String fmtLn(XmlLineNumber line) {
        return String.format("%d,%d", line.getLine(), line.getColumn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlLineNumber getXmlLineNumber(XmlTokenSource src) {
        XmlLineNumber ln = null;
        XmlCursor c = null;
        try {
            c = src.newCursor();
            ln = (XmlLineNumber)c.getBookmark(XmlLineNumber.class);
            if (ln == null) {
                ln = (XmlLineNumber)c.toPrevBookmark(XmlLineNumber.class);
            }
        }
        finally {
            if (c != null) {
                c.dispose();
            }
        }
        return ln;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getText(XmlTokenSource src) {
        XmlCursor c = null;
        try {
            c = src.newCursor();
            String string = c.getTextValue();
            return string;
        }
        finally {
            if (c != null) {
                c.dispose();
            }
        }
    }

    @Nonnull
    public static final XmlObject[] toXmlObjects(@Nonnull XmlObject xmlObject, @Nonnull String xmlPath) {
        return xmlObject.selectPath(xmlPath);
    }

    public static final boolean toXmlBoolean(@Nonnull XmlObject xmlObject, @Nonnull String xmlPath) {
        return Boolean.valueOf(XmlBeansHelper.toXmlString(xmlObject, xmlPath));
    }

    public static final int toXmlInteger(@Nonnull XmlObject xmlObject, @Nonnull String xmlPath) {
        String value = XmlBeansHelper.toXmlString(xmlObject, xmlPath);
        return value.isEmpty() ? 0 : Integer.valueOf(value);
    }

    @Nonnull
    public static final String toXmlString(@Nonnull XmlObject xmlObject, @Nonnull String xmlPath) {
        XmlObject xml = XmlBeansHelper.toXmlObject(xmlObject, xmlPath);
        return xml != null ? xml.newCursor().getTextValue() : "";
    }

    @Nullable
    public static final XmlObject toXmlObject(@Nonnull XmlObject xmlObject, @Nonnull String xmlPath) {
        XmlObject[] xmlObjects = xmlObject.selectPath(xmlPath);
        return xmlObjects.length > 0 ? xmlObjects[0] : null;
    }

    public static XmlOptions getXmlOptionsWithDisabledXXE() {
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setEntityResolver(new EntityListener());
        xmlOptions.setLoadLineNumbers();
        return xmlOptions;
    }

    private static class EntityListener
    implements EntityResolver {
        private EntityListener() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    }
}

