/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;

public class XML1_0ToXML1_1ConversionFilterReader
extends FilterReader {
    public static final Set<Integer> CONTROL_CHARS_TO_BE_ESCAPED = new HashSet<Integer>(Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 11, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31));
    public static final Set<Integer> CONTROL_CHARS_TO_BE_SKIPPED = new HashSet<Integer>(Arrays.asList(127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159));
    private Queue<Character> bufffer = new LinkedList<Character>();
    private Parser parser = new Parser();

    public XML1_0ToXML1_1ConversionFilterReader(Reader reader) {
        super(reader);
    }

    @Override
    public int read() throws IOException {
        if (this.parser.isXML() && !this.bufffer.isEmpty()) {
            return this.bufffer.remove().charValue();
        }
        int read = super.read();
        boolean okToReturn = true;
        if (this.parser.isXML()) {
            if (!this.parser.prologEnded()) {
                if (this.parser.versionNotDone()) {
                    okToReturn = this.parser.parseProlog((char)read);
                    if (this.parser.version1_0Encountered()) {
                        return 49;
                    }
                }
                if (this.parser.versionNotFound()) {
                    this.parser.setVersionFound(true);
                    this.parser.setVersionDone(true);
                    this.bufffer.add(Character.valueOf(' '));
                    this.bufffer.add(Character.valueOf('v'));
                    this.bufffer.add(Character.valueOf('e'));
                    this.bufffer.add(Character.valueOf('r'));
                    this.bufffer.add(Character.valueOf('s'));
                    this.bufffer.add(Character.valueOf('i'));
                    this.bufffer.add(Character.valueOf('o'));
                    this.bufffer.add(Character.valueOf('n'));
                    this.bufffer.add(Character.valueOf('='));
                    this.bufffer.add(Character.valueOf('\"'));
                    this.bufffer.add(Character.valueOf('1'));
                    this.bufffer.add(Character.valueOf('.'));
                    this.bufffer.add(Character.valueOf('1'));
                    this.bufffer.add(Character.valueOf('\"'));
                    this.bufffer.add(Character.valueOf('?'));
                    this.bufffer.add(Character.valueOf((char)read));
                    return this.bufffer.remove().charValue();
                }
            }
            if (!okToReturn) {
                return this.read();
            }
            if (CONTROL_CHARS_TO_BE_SKIPPED.contains(read)) {
                return this.read();
            }
            if (CONTROL_CHARS_TO_BE_ESCAPED.contains(read)) {
                this.bufffer.add(Character.valueOf('&'));
                this.bufffer.add(Character.valueOf('#'));
                String string = Integer.toString(read);
                int length = string.length();
                if (length == 1) {
                    this.bufffer.add(Character.valueOf('0'));
                    this.bufffer.add(Character.valueOf(string.charAt(0)));
                } else {
                    for (int i = 0; i < length; ++i) {
                        this.bufffer.add(Character.valueOf(string.charAt(i)));
                    }
                }
                this.bufffer.add(Character.valueOf(';'));
                return this.bufffer.remove().charValue();
            }
            return read;
        }
        return read;
    }

    @Override
    public int read(char[] ac, int i, int j) throws IOException {
        int count = 0;
        for (int k = i; k < j; ++k) {
            int read = this.read();
            if (read == -1) {
                count = count == 0 ? read : count;
                break;
            }
            ac[k] = (char)read;
            ++count;
        }
        return count;
    }

    @Override
    public long skip(long l) throws IOException {
        throw new UnsupportedOperationException("No skipping! Read everything please!");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.bufffer.clear();
    }

    private class Parser {
        char[] prologStart = new char[]{'<', '?', 'x', 'm', 'l', ' '};
        int prologStartPointer = 0;
        char[] prologEnd = new char[]{'?', '>'};
        int prologEndPointer = 0;
        boolean prologStarted;
        boolean prologEnded;
        char[] versionAttribute = new char[]{'v', 'e', 'r', 's', 'i', 'o', 'n', '=', '\"', '1', '.', '0'};
        int versionAttributePointer = 0;
        boolean version1_0_encountered;
        boolean versionDone;
        boolean xml = true;
        boolean versionFound = true;

        private Parser() {
        }

        boolean prologEnded() {
            return this.prologEnded;
        }

        void setVersionDone(boolean versionDone) {
            this.versionDone = versionDone;
        }

        void setVersionFound(boolean versionFound) {
            this.versionFound = versionFound;
        }

        public boolean versionNotFound() {
            return !this.versionFound;
        }

        public boolean isXML() {
            return this.xml;
        }

        boolean version1_0Encountered() {
            return this.version1_0_encountered;
        }

        void startProlog() {
            this.prologStarted = true;
            this.setIsXML(true);
        }

        void endProlog() {
            this.prologEnded = true;
            if (this.versionNotDone()) {
                this.setVersionFound(false);
            }
        }

        boolean prologNotStarted() {
            return !this.prologStarted;
        }

        boolean parsePrologStart(char c) {
            if (c == this.prologStart[this.prologStartPointer]) {
                ++this.prologStartPointer;
                if (this.prologStartPointer >= this.prologStart.length) {
                    this.startProlog();
                }
            } else {
                this.prologStartPointer = 0;
                this.setIsXML(false);
            }
            return true;
        }

        void setIsXML(boolean xml) {
            this.xml = xml;
        }

        boolean parseProlog(char c) {
            boolean returnFlag = true;
            if (this.prologNotStarted()) {
                returnFlag &= this.parsePrologStart(c);
            } else if (!this.prologEnded()) {
                returnFlag &= this.parsePrologEnd(c);
            }
            if (this.versionNotDone()) {
                returnFlag &= this.parseVersion(c);
            }
            return returnFlag;
        }

        boolean versionNotDone() {
            return !this.versionDone;
        }

        boolean parsePrologEnd(char c) {
            if (c == this.prologEnd[this.prologEndPointer]) {
                ++this.prologEndPointer;
                if (this.prologEndPointer >= this.prologEnd.length) {
                    this.endProlog();
                }
                if (this.versionNotDone()) {
                    return false;
                }
            } else {
                this.prologEndPointer = 0;
            }
            return true;
        }

        boolean parseVersion(char c) {
            if (c == this.versionAttribute[this.versionAttributePointer]) {
                ++this.versionAttributePointer;
                if (this.versionAttributePointer >= this.versionAttribute.length) {
                    this.versionDone = true;
                    this.version1_0_encountered = true;
                }
            } else if (c == '1' && this.versionAttribute[this.versionAttributePointer - 1] == '.') {
                this.versionDone = true;
                this.version1_0_encountered = false;
            } else {
                this.versionAttributePointer = 0;
            }
            return true;
        }
    }
}

