/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class UnicodeUtil {

    public static class CJKCompatibility {
        private List<CharMatchingGroup> matchingGroups = new ArrayList<CharMatchingGroup>();
        private Map<Character, Character> charMap = new HashMap<Character, Character>();
        private Map<Character, Character> overrideCharMap = new HashMap<Character, Character>();
        private Map<Character, String> multiCharMap = new HashMap<Character, String>();
        private Map<Character, String> verticalOnlyMultiCharMap = new HashMap<Character, String>();
        private boolean useMultiCharMapping = true;
        private String DEFAULT_OVERRIDE_MAP_FILE = "Resources/CJKMap.properties";

        public CJKCompatibility() {
            this.matchingGroups.add(new CharMatchingGroup("Fullwidth ASCII variants", '!', '~', 65248));
            this.matchingGroups.add(new CharMatchingGroup("Fullwidth brackets", '\u2985', '\u2986', 54746));
            this.matchingGroups.add(new CharMatchingGroup("Halfwidth Hangul variants", "Group 1", '\uffa1', '\uffbe', -52848));
            this.matchingGroups.add(new CharMatchingGroup("Halfwidth Hangul variants", "Group 2", '\uffc2', '\uffc7', -52851));
            this.matchingGroups.add(new CharMatchingGroup("Halfwidth Hangul variants", "Group 3", '\uffca', '\uffcf', -52853));
            this.matchingGroups.add(new CharMatchingGroup("Halfwidth Hangul variants", "Group 4", '\uffd2', '\uffd7', -52855));
            this.matchingGroups.add(new CharMatchingGroup("Halfwidth Hangul variants", "Group 5", '\uffda', '\uffdc', -52857));
            this.matchingGroups.add(new CharMatchingGroup("Halfwidth Hangul variants", "Group 6", '\uffa0', '\uffa0', -52796));
            this.charMap.put(Character.valueOf('\uff61'), Character.valueOf('\u3002'));
            this.charMap.put(Character.valueOf('\uff64'), Character.valueOf('\u3001'));
            this.charMap.put(Character.valueOf('\u00a2'), Character.valueOf('\uffe0'));
            this.charMap.put(Character.valueOf('\u00a3'), Character.valueOf('\uffe1'));
            this.charMap.put(Character.valueOf('\u00ac'), Character.valueOf('\uffe2'));
            this.charMap.put(Character.valueOf('\u00af'), Character.valueOf('\uffe3'));
            this.charMap.put(Character.valueOf('\u00a6'), Character.valueOf('\uffe4'));
            this.charMap.put(Character.valueOf('\u00a5'), Character.valueOf('\uffe5'));
            this.charMap.put(Character.valueOf('\u20a9'), Character.valueOf('\uffe6'));
            this.charMap.put(Character.valueOf('\uffe8'), Character.valueOf('\u2502'));
            this.charMap.put(Character.valueOf('\uffe9'), Character.valueOf('\u2190'));
            this.charMap.put(Character.valueOf('\uffea'), Character.valueOf('\u2191'));
            this.charMap.put(Character.valueOf('\uffeb'), Character.valueOf('\u2192'));
            this.charMap.put(Character.valueOf('\uffec'), Character.valueOf('\u2193'));
            this.charMap.put(Character.valueOf('\uffed'), Character.valueOf('\u25a0'));
            this.charMap.put(Character.valueOf('\uffee'), Character.valueOf('\u25cb'));
            this.charMap.put(Character.valueOf('\uff65'), Character.valueOf('\u30fb'));
            this.charMap.put(Character.valueOf('\uff66'), Character.valueOf('\u30f2'));
            this.charMap.put(Character.valueOf('\uff67'), Character.valueOf('\u30a1'));
            this.charMap.put(Character.valueOf('\uff68'), Character.valueOf('\u30a3'));
            this.charMap.put(Character.valueOf('\uff69'), Character.valueOf('\u30a5'));
            this.charMap.put(Character.valueOf('\uff6a'), Character.valueOf('\u30a7'));
            this.charMap.put(Character.valueOf('\uff6b'), Character.valueOf('\u30a9'));
            this.charMap.put(Character.valueOf('\uff6c'), Character.valueOf('\u30e3'));
            this.charMap.put(Character.valueOf('\uff6d'), Character.valueOf('\u30e5'));
            this.charMap.put(Character.valueOf('\uff6e'), Character.valueOf('\u30e7'));
            this.charMap.put(Character.valueOf('\uff6f'), Character.valueOf('\u30c3'));
            this.charMap.put(Character.valueOf('\uff70'), Character.valueOf('\u30fc'));
            this.charMap.put(Character.valueOf('\uff71'), Character.valueOf('\u30a2'));
            this.charMap.put(Character.valueOf('\uff72'), Character.valueOf('\u30a4'));
            this.charMap.put(Character.valueOf('\uff73'), Character.valueOf('\u30a6'));
            this.charMap.put(Character.valueOf('\uff74'), Character.valueOf('\u30a8'));
            this.charMap.put(Character.valueOf('\uff75'), Character.valueOf('\u30aa'));
            this.charMap.put(Character.valueOf('\uff76'), Character.valueOf('\u30ab'));
            this.charMap.put(Character.valueOf('\uff77'), Character.valueOf('\u30ad'));
            this.charMap.put(Character.valueOf('\uff78'), Character.valueOf('\u30af'));
            this.charMap.put(Character.valueOf('\uff79'), Character.valueOf('\u30b1'));
            this.charMap.put(Character.valueOf('\uff7a'), Character.valueOf('\u30b3'));
            this.charMap.put(Character.valueOf('\uff7b'), Character.valueOf('\u30b5'));
            this.charMap.put(Character.valueOf('\uff7c'), Character.valueOf('\u30b7'));
            this.charMap.put(Character.valueOf('\uff7d'), Character.valueOf('\u30b9'));
            this.charMap.put(Character.valueOf('\uff7e'), Character.valueOf('\u30bb'));
            this.charMap.put(Character.valueOf('\uff7f'), Character.valueOf('\u30bd'));
            this.charMap.put(Character.valueOf('\uff80'), Character.valueOf('\u30bf'));
            this.charMap.put(Character.valueOf('\uff81'), Character.valueOf('\u30c1'));
            this.charMap.put(Character.valueOf('\uff82'), Character.valueOf('\u30c4'));
            this.charMap.put(Character.valueOf('\uff83'), Character.valueOf('\u30c6'));
            this.charMap.put(Character.valueOf('\uff84'), Character.valueOf('\u30c8'));
            this.charMap.put(Character.valueOf('\uff85'), Character.valueOf('\u30ca'));
            this.charMap.put(Character.valueOf('\uff86'), Character.valueOf('\u30cb'));
            this.charMap.put(Character.valueOf('\uff87'), Character.valueOf('\u30cc'));
            this.charMap.put(Character.valueOf('\uff88'), Character.valueOf('\u30cd'));
            this.charMap.put(Character.valueOf('\uff89'), Character.valueOf('\u30ce'));
            this.charMap.put(Character.valueOf('\uff8a'), Character.valueOf('\u30cf'));
            this.charMap.put(Character.valueOf('\uff8b'), Character.valueOf('\u30d2'));
            this.charMap.put(Character.valueOf('\uff8c'), Character.valueOf('\u30d5'));
            this.charMap.put(Character.valueOf('\uff8d'), Character.valueOf('\u30d8'));
            this.charMap.put(Character.valueOf('\uff8e'), Character.valueOf('\u30db'));
            this.charMap.put(Character.valueOf('\uff8f'), Character.valueOf('\u30de'));
            this.charMap.put(Character.valueOf('\uff90'), Character.valueOf('\u30df'));
            this.charMap.put(Character.valueOf('\uff91'), Character.valueOf('\u30e0'));
            this.charMap.put(Character.valueOf('\uff92'), Character.valueOf('\u30e1'));
            this.charMap.put(Character.valueOf('\uff93'), Character.valueOf('\u30e2'));
            this.charMap.put(Character.valueOf('\uff94'), Character.valueOf('\u30e4'));
            this.charMap.put(Character.valueOf('\uff95'), Character.valueOf('\u30e6'));
            this.charMap.put(Character.valueOf('\uff96'), Character.valueOf('\u30e8'));
            this.charMap.put(Character.valueOf('\uff97'), Character.valueOf('\u30e9'));
            this.charMap.put(Character.valueOf('\uff98'), Character.valueOf('\u30ea'));
            this.charMap.put(Character.valueOf('\uff99'), Character.valueOf('\u30eb'));
            this.charMap.put(Character.valueOf('\uff9a'), Character.valueOf('\u30ec'));
            this.charMap.put(Character.valueOf('\uff9b'), Character.valueOf('\u30ed'));
            this.charMap.put(Character.valueOf('\uff9c'), Character.valueOf('\u30ef'));
            this.charMap.put(Character.valueOf('\uff9d'), Character.valueOf('\u30f3'));
            this.charMap.put(Character.valueOf('\uff9e'), Character.valueOf('\u3099'));
            this.charMap.put(Character.valueOf('\uff9f'), Character.valueOf('\u309a'));
            this.charMap.put(Character.valueOf('\u2025'), Character.valueOf('\ufe30'));
            this.charMap.put(Character.valueOf('\u2014'), Character.valueOf('\ufe31'));
            this.charMap.put(Character.valueOf('\u2013'), Character.valueOf('\ufe32'));
            this.charMap.put(Character.valueOf('\u2015'), Character.valueOf('\ufe31'));
            this.charMap.put(Character.valueOf('\u201c'), Character.valueOf('\u301d'));
            this.charMap.put(Character.valueOf('\u201d'), Character.valueOf('\u301f'));
            this.charMap.put(Character.valueOf('_'), Character.valueOf('\ufe33'));
            this.charMap.put(Character.valueOf('-'), Character.valueOf('\ufe32'));
            this.charMap.put(Character.valueOf('('), Character.valueOf('\ufe35'));
            this.charMap.put(Character.valueOf(')'), Character.valueOf('\ufe36'));
            this.charMap.put(Character.valueOf('{'), Character.valueOf('\ufe37'));
            this.charMap.put(Character.valueOf('}'), Character.valueOf('\ufe38'));
            this.charMap.put(Character.valueOf('\u3014'), Character.valueOf('\ufe39'));
            this.charMap.put(Character.valueOf('\u3015'), Character.valueOf('\ufe3a'));
            this.charMap.put(Character.valueOf('\u3010'), Character.valueOf('\ufe3b'));
            this.charMap.put(Character.valueOf('\u3011'), Character.valueOf('\ufe3c'));
            this.charMap.put(Character.valueOf('\u300a'), Character.valueOf('\ufe3d'));
            this.charMap.put(Character.valueOf('\u300b'), Character.valueOf('\ufe3e'));
            this.charMap.put(Character.valueOf('\u3008'), Character.valueOf('\ufe3f'));
            this.charMap.put(Character.valueOf('\u3009'), Character.valueOf('\ufe40'));
            this.charMap.put(Character.valueOf('\u300c'), Character.valueOf('\ufe41'));
            this.charMap.put(Character.valueOf('\u300d'), Character.valueOf('\ufe42'));
            this.charMap.put(Character.valueOf('\uff62'), Character.valueOf('\ufe41'));
            this.charMap.put(Character.valueOf('\uff63'), Character.valueOf('\ufe42'));
            this.charMap.put(Character.valueOf('\u300e'), Character.valueOf('\ufe43'));
            this.charMap.put(Character.valueOf('\u300f'), Character.valueOf('\ufe44'));
            this.charMap.put(Character.valueOf('\ufe51'), Character.valueOf('\ufe45'));
            this.charMap.put(Character.valueOf('['), Character.valueOf('\ufe47'));
            this.charMap.put(Character.valueOf(']'), Character.valueOf('\ufe48'));
            this.charMap.put(Character.valueOf('\u203e'), Character.valueOf('\ufe49'));
            this.verticalOnlyMultiCharMap.put(Character.valueOf('\u2026'), new String(new char[]{'\u30fb', '\u30fb', '\u30fb'}));
            this.verticalOnlyMultiCharMap.put(Character.valueOf('\u22ee'), new String(new char[]{'\u30fb', '\u30fb', '\u30fb'}));
            this.multiCharMap.put(Character.valueOf('\u2e3a'), new String(new char[]{'\u2014', '\u2014'}));
            this.multiCharMap.put(Character.valueOf('\u2e3b'), new String(new char[]{'\u2014', '\u2014', '\u2014'}));
        }

        public char halfToFullWidth(char c) {
            if (this.charMap.containsKey(Character.valueOf(c))) {
                return this.charMap.get(Character.valueOf(c)).charValue();
            }
            for (CharMatchingGroup matchingGroup : this.matchingGroups) {
                if (c < matchingGroup.min || c > matchingGroup.max) continue;
                return (char)(c + matchingGroup.diff);
            }
            return c;
        }

        public char halfToFullWidth(char c, Map<Character, Character> overrideMap) {
            if (overrideMap.containsKey(Character.valueOf(c))) {
                return overrideMap.get(Character.valueOf(c)).charValue();
            }
            return this.halfToFullWidth(c);
        }

        public String halfToFullWidth(String s) {
            boolean useOverrideMap = this.overrideCharMap != null && !this.overrideCharMap.keySet().isEmpty();
            int STRING_INIT_CAPACITY = s.length() + 1;
            StringBuilder sb = new StringBuilder(STRING_INIT_CAPACITY);
            for (int i = 0; i < s.length(); ++i) {
                char fromChar = s.charAt(i);
                if (useOverrideMap && this.overrideCharMap.containsKey(Character.valueOf(fromChar))) {
                    sb.append(this.overrideCharMap.get(Character.valueOf(fromChar)));
                    continue;
                }
                if (this.verticalOnlyMultiCharMap.containsKey(Character.valueOf(fromChar))) {
                    sb.append(this.verticalOnlyMultiCharMap.get(Character.valueOf(fromChar)));
                    continue;
                }
                sb.append(this.halfToFullWidth(fromChar));
            }
            return sb.toString();
        }

        public String mapMultiChar(String s) {
            int STRING_INIT_CAPACITY = s.length() + 1;
            StringBuilder sb = new StringBuilder(STRING_INIT_CAPACITY);
            for (int i = 0; i < s.length(); ++i) {
                char fromChar = s.charAt(i);
                if (this.multiCharMap.containsKey(Character.valueOf(fromChar))) {
                    sb.append(this.multiCharMap.get(Character.valueOf(fromChar)));
                    continue;
                }
                sb.append(fromChar);
            }
            return sb.toString();
        }

        public void setOverrideMap(String filename) {
            if (filename == null || filename.isEmpty()) {
                filename = this.DEFAULT_OVERRIDE_MAP_FILE;
            }
            try {
                this.setOverrideMap(new FileInputStream(filename));
            }
            catch (IOException e) {
                System.out.println("IOException processing override properties file. Proceeding without override.");
                e.printStackTrace();
            }
        }

        public void setOverrideMap(FileInputStream f) {
            try {
                this.setOverrideMap(new CharPropertiesMap(f).getCharacterMap());
            }
            catch (IOException e) {
                System.out.println("IOException processing override properties file. Proceeding without override.");
                e.printStackTrace();
            }
        }

        public void setOverrideMap(Map<Character, Character> overrideCharMap) {
            this.overrideCharMap = new HashMap<Character, Character>();
            this.overrideCharMap.putAll(overrideCharMap);
        }

        public void setOverrideMap() {
            this.setOverrideMap("");
        }

        public void addToOverrideMap(Map<Character, Character> overrideCharMap) {
            this.overrideCharMap.putAll(overrideCharMap);
        }

        public void resetOverrideMap() {
            this.overrideCharMap = new HashMap<Character, Character>();
        }

        public void shouldUseMultiCharMapping(boolean b) {
            this.useMultiCharMapping = b;
        }

        public boolean getShouldUseMultiCharMapping() {
            return this.useMultiCharMapping;
        }
    }

    public static class CharPropertiesMap {
        private Properties stringProperties = new Properties();

        public CharPropertiesMap() {
        }

        public CharPropertiesMap(InputStream is) throws IOException {
            this();
            this.load(is);
        }

        public CharPropertiesMap(Reader r) throws IOException {
            this();
            this.load(r);
        }

        public void load(InputStream is) throws IOException {
            this.stringProperties.load(is);
        }

        public void load(Reader r) throws IOException {
            this.stringProperties.load(r);
        }

        public static Map<Character, Character> getCharacterMap(Map<Object, Object> map) {
            HashMap<Character, Character> characterMap = new HashMap<Character, Character>();
            int BASE_SIXTEEN = 16;
            for (Object key : map.keySet()) {
                Object value = map.get(key);
                try {
                    char charKey = (char)Integer.parseInt(key.toString().trim(), 16);
                    char charValue = (char)Integer.parseInt(value.toString().trim(), 16);
                    characterMap.put(Character.valueOf(charKey), Character.valueOf(charValue));
                }
                catch (NumberFormatException e) {}
            }
            return characterMap;
        }

        public Map<Character, Character> getCharacterMap() {
            return CharPropertiesMap.getCharacterMap(this.stringProperties);
        }

        public Properties getProperties() {
            return this.stringProperties;
        }
    }

    private static class CharMatchingGroup {
        protected String name;
        protected String subName;
        protected char min;
        protected char max;
        protected int diff;

        public CharMatchingGroup(String name, String subName, char min, char max, int diff) {
            this.name = name;
            this.subName = subName;
            this.min = min;
            this.max = max;
            this.diff = diff;
        }

        public CharMatchingGroup(String name, char min, char max, int diff) {
            this(name, "", min, max, diff);
        }
    }
}

