/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.util;

import com.apple.jingle.leghorn.timecode.QTTextTimeCode;
import com.apple.jingle.leghorn.timecode.SMPTETimeCode;
import com.apple.jingle.leghorn.timecode.TimeCode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeCodeUtil {
    public static TimeCode parseTimeCode(String time, String format) {
        Pattern fullTimeCode = Pattern.compile("^([0-9]+:[0-9]+:[0-9]+)[:;][0-9]+$");
        Pattern partialTimeCode = Pattern.compile("^([0-9]+:[0-9]+:[0-9]+).*$");
        if ("qt_text".equals(format)) {
            Matcher m = QTTextTimeCode.QTTEXT_TIMECODE.matcher(time);
            if (m.matches()) {
                return QTTextTimeCode.parseQTTextString(time);
            }
            m = partialTimeCode.matcher(time);
            if (m.matches()) {
                return SMPTETimeCode.parseTimeCode(m.group(1), format);
            }
        } else {
            Matcher m = fullTimeCode.matcher(time);
            if (m.matches()) {
                return SMPTETimeCode.parseTimeCode(time, format);
            }
            m = partialTimeCode.matcher(time);
            if (m.matches()) {
                SMPTETimeCode.Mode mode = SMPTETimeCode.guessMode(time + ":00 " + format);
                if (mode.isDrop()) {
                    return SMPTETimeCode.parseTimeCode(m.group(1) + ";00", format);
                }
                return SMPTETimeCode.parseTimeCode(m.group(1) + ":00", format);
            }
        }
        throw new RuntimeException("Unable to generate TimeCode object from time: " + time + " format: " + format);
    }
}

