/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.util;

import com.apple.jingle.leghorn.timecode.MillisTimeCode;
import com.apple.jingle.leghorn.timecode.TimeCode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class TimeCodeInterval {
    protected final TimeCode _begin;
    protected final TimeCode _end;
    public static final TimeCodeInterval INVALID = new TimeCodeInterval();

    public TimeCodeInterval(@Nonnull TimeCode begin, @Nonnull TimeCode end) {
        this._begin = begin;
        this._end = end;
    }

    private TimeCodeInterval() {
        this._begin = null;
        this._end = null;
    }

    public TimeCode begin() {
        return this._begin;
    }

    public TimeCode end() {
        return this._end;
    }

    public boolean isValid() {
        if (this._begin == null || this._end == null) {
            return false;
        }
        return this._begin.getMediaTime().getSampleCount() > 0L && this._end.getMediaTime().getSampleCount() > 0L && this._begin.getMediaTime().getRate().getRatioToSeconds().denominator() > 0L && this._end.getMediaTime().getRate().getRatioToSeconds().denominator() > 0L;
    }

    static List<TimeCodeInterval> findOverlaps(List<TimeCodeInterval> intervals) {
        ArrayList result = Lists.newArrayList();
        if (intervals.isEmpty()) {
            return result;
        }
        ArrayList active = Lists.newArrayList((Object[])new TimeCodeInterval[]{intervals.get(0)});
        intervals.remove(0);
        while (!active.isEmpty()) {
        }
        return result;
    }

    TimeCodeInterval substract(TimeCodeInterval b) {
        TimeCode t0 = null;
        TimeCode t1 = null;
        if (b._begin.getTotalMilliseconds() < this._end.getTotalMilliseconds()) {
            t0 = this._begin;
            t1 = b._begin;
        }
        if (b._begin.getTotalMilliseconds() >= this._end.getTotalMilliseconds()) {
            t0 = b._end;
            t1 = this._end;
        }
        if (t0 == null || t1 == null || t1.getTotalMilliseconds() < t1.getTotalMilliseconds()) {
            return INVALID;
        }
        return new TimeCodeInterval(t0, t1);
    }

    public TimeCodeInterval intersect(TimeCodeInterval b) {
        TimeCode maxBegin = this._begin;
        TimeCode minEnd = this._end;
        if (b._begin.getTotalMilliseconds() > this._begin.getTotalMilliseconds()) {
            maxBegin = b._begin;
        }
        if (b._end.getTotalMilliseconds() < this._end.getTotalMilliseconds()) {
            minEnd = b._end;
        }
        if (maxBegin.getTotalMilliseconds() < minEnd.getTotalMilliseconds()) {
            return new TimeCodeInterval(maxBegin, minEnd);
        }
        return INVALID;
    }

    private static void printInterval(TimeCodeInterval interval) {
        if (interval == INVALID) {
            System.out.println("Invalid");
        } else {
            System.out.println(String.format("[%s,%s]", interval.begin(), interval.end()));
        }
    }

    public static void main(String[] args) {
        TimeCodeInterval a = new TimeCodeInterval(MillisTimeCode.parseMillis(0L), MillisTimeCode.parseMillis(7L));
        TimeCodeInterval b = new TimeCodeInterval(MillisTimeCode.parseMillis(5L), MillisTimeCode.parseMillis(8L));
        TimeCodeInterval c = new TimeCodeInterval(MillisTimeCode.parseMillis(9L), MillisTimeCode.parseMillis(15L));
        TimeCodeInterval d = new TimeCodeInterval(MillisTimeCode.parseMillis(8L), MillisTimeCode.parseMillis(15L));
        TimeCodeInterval e = new TimeCodeInterval(MillisTimeCode.parseMillis(2L), MillisTimeCode.parseMillis(4L));
        TimeCodeInterval.printInterval(a.intersect(c));
        TimeCodeInterval.printInterval(b.intersect(c));
        TimeCodeInterval.printInterval(b.intersect(a));
        TimeCodeInterval.printInterval(a.intersect(b));
        TimeCodeInterval.printInterval(a.intersect(a));
        TimeCodeInterval.printInterval(c.intersect(b));
        TimeCodeInterval.printInterval(d.intersect(b));
        TimeCodeInterval.printInterval(b.intersect(d));
        TimeCodeInterval.printInterval(a.intersect(e));
        TimeCodeInterval.printInterval(e.intersect(a));
    }

    public String toString() {
        return "TimeCodeInterval{_begin=" + this._begin + ", _end=" + this._end + '}';
    }
}

