/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.util;

import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.types.SubtitleDocumentDescriberVerifier;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TTMLSchemaValidationHelper {
    private static final Logger logger = Logger.getLogger(TTMLSchemaValidationHelper.class);

    public static void validateWithRNCSchema(InputStream is, String schemaLocation) throws IOException, DescriptionException {
        PropertyMapBuilder properties = new PropertyMapBuilder();
        properties.put(ValidateProperty.ERROR_HANDLER, (Object)new ErrorListener());
        properties.put(ValidateProperty.ENTITY_RESOLVER, (Object)new EntityListener());
        properties.put(ValidateProperty.URI_RESOLVER, (Object)new URIListener());
        RngProperty.CHECK_ID_IDREF.add(properties);
        SchemaReader ttmlSchemaReader = CompactSchemaReader.getInstance();
        ValidationDriver ttmlDriver = new ValidationDriver(properties.toPropertyMap(), ttmlSchemaReader);
        InputSource schemaSource = new InputSource(SubtitleDocumentDescriberVerifier.class.getResourceAsStream(schemaLocation));
        try {
            boolean ttmlSchemaOK = ttmlDriver.loadSchema(schemaSource);
            if (!ttmlSchemaOK) {
                throw new RuntimeException("Schema failed to load from " + schemaLocation);
            }
        }
        catch (SAXException se) {
            throw ErrorListener.getDescriptionException(se);
        }
        InputSource inputSource = new InputSource(is);
        try {
            boolean fileValid = ttmlDriver.validate(inputSource);
            if (!fileValid) {
                throw new RuntimeException("Document not valid. Schema: " + schemaLocation);
            }
        }
        catch (SAXException se) {
            throw ErrorListener.getDescriptionException(se);
        }
    }

    private static class URIListener
    implements URIResolver {
        private URIListener() {
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            StreamSource constantResult = new StreamSource(new ByteArrayInputStream("".getBytes()));
            return constantResult;
        }
    }

    private static class EntityListener
    implements EntityResolver {
        private EntityListener() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    }

    private static class ErrorListener
    implements ErrorHandler {
        private ErrorListener() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            logger.warn((Object)"SAX Warning", (Throwable)exception);
        }

        public static DescriptionException getDescriptionException(SAXException se) {
            if (se instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)se;
                return new DescriptionException(spe.toString(), new ValidationError(spe.getMessage(), -1L, spe.getLineNumber(), spe.getColumnNumber()));
            }
            return new DescriptionException(se);
        }
    }
}

