/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.util;

import java.util.ArrayList;
import java.util.List;

public class SimpleArgParse {
    private List<ArgInfo> _argInfoList = new ArrayList<ArgInfo>();
    private static final ArgInfo NULL_INFO = new ArgInfo();

    public void parse(String[] args) {
        boolean loadValue = false;
        ArgInfo info = NULL_INFO;
        for (int ii = 0; ii < args.length; ++ii) {
            if (args[ii] == null) {
                throw new IllegalArgumentException("Invalid command line");
            }
            String s = args[ii];
            if (s.startsWith("-")) {
                info = this.findArgByName(s = s.replaceAll("-", ""));
                if (info == NULL_INFO) continue;
                if (!info.value().isEmpty()) {
                    throw new IllegalArgumentException("Duplicated argument:" + info.name());
                }
                if (info.isFlag()) {
                    info.setValue("true");
                    continue;
                }
                loadValue = true;
                continue;
            }
            if (!loadValue) continue;
            if (info == NULL_INFO) {
                throw new IllegalArgumentException("Invalid command line");
            }
            info.setValue(s);
            loadValue = false;
        }
        for (ArgInfo af : this._argInfoList) {
            if (!af.required() || !af.value().isEmpty()) continue;
            throw new IllegalArgumentException("Missing required argument:" + af.name());
        }
    }

    public SimpleArgParse addArgument(String name, String shortName) {
        return this.addArgument(name, shortName, true, "");
    }

    public SimpleArgParse addArgument(String name, String shortName, boolean required, String defaultValue) {
        ArgInfo x = this.findArgByName(name);
        ArgInfo y = this.findArgByName(shortName);
        if (x != NULL_INFO || y != NULL_INFO) {
            throw new IllegalArgumentException("Argument name " + name + " or " + shortName + " already defined:");
        }
        this._argInfoList.add(new ArgInfo(name, shortName, required, defaultValue));
        return this;
    }

    public void removeArgument(String name) {
        ArgInfo x = this.findArgByName(name);
        if (x != NULL_INFO) {
            this._argInfoList.remove(x);
        }
    }

    public SimpleArgParse addFlag(String name, String shortName, boolean defaultValue) {
        ArgInfo x = this.findArgByName(name);
        ArgInfo y = this.findArgByName(shortName);
        if (x != NULL_INFO || y != NULL_INFO) {
            throw new IllegalArgumentException("Argument name " + name + " or " + shortName + " already defined:");
        }
        ArgInfo info = new ArgInfo(name, shortName, false, defaultValue ? "true" : "false");
        info.setIsFlag(true);
        this._argInfoList.add(info);
        return this;
    }

    public String getArgumentValue(String name) {
        ArgInfo argInfo = this.findArgByName(name);
        if (!argInfo.value().isEmpty()) {
            return argInfo.value();
        }
        return argInfo.defaultValue();
    }

    public boolean isFlagSet(String name) {
        ArgInfo argInfo = this.findArgByName(name);
        if (argInfo.isFlag()) {
            return !argInfo.value().isEmpty();
        }
        return false;
    }

    private ArgInfo findArgByName(String name) {
        if (name == null || name.isEmpty()) {
            return NULL_INFO;
        }
        for (ArgInfo info : this._argInfoList) {
            if (!info.isNamed(name)) continue;
            return info;
        }
        return NULL_INFO;
    }

    static class ArgInfo {
        private String _name;
        private String _shortName;
        private boolean _required;
        private boolean _isFlag;
        private String _value;
        private String _defaultValue;

        public String name() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public String shortName() {
            return this._shortName;
        }

        public void setShortName(String shortName) {
            this._shortName = shortName;
        }

        public boolean required() {
            return this._required;
        }

        public void setRequired(boolean required) {
            this._required = required;
        }

        public String value() {
            return this._value;
        }

        public void setValue(String value) {
            this._value = value;
        }

        public String defaultValue() {
            return this._defaultValue;
        }

        public void setDefaultValue(String value) {
            this._defaultValue = value;
        }

        public boolean isFlag() {
            return this._isFlag;
        }

        public void setIsFlag(boolean v) {
            this._isFlag = v;
        }

        public ArgInfo(String name, String shortName, boolean required, String defaultValue) {
            this._name = name;
            this._shortName = shortName;
            this._required = required;
            this._value = "";
            this._defaultValue = defaultValue;
            this._isFlag = false;
        }

        public ArgInfo() {
            this("", "", false, "");
        }

        public boolean isNamed(String name) {
            if (this._name.isEmpty() || this._shortName.isEmpty()) {
                return false;
            }
            if (name == null || name.isEmpty()) {
                return false;
            }
            return this._name.compareTo(name) == 0 || this._shortName.compareTo(name) == 0;
        }
    }
}

