/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.util;

import com.apple.jingle.leghorn.util.javacc.ParseException;
import com.apple.jingle.leghorn.util.javacc.PlistParserJavaCC;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.Normalizer;
import org.apache.log4j.Logger;

public class PlistParser {
    public final Normalizer.Form normalizerForm;
    private final Logger LOGGER = Logger.getLogger(PlistParser.class);

    public PlistParser() {
        this(null);
    }

    public PlistParser(Normalizer.Form normalizerForm) {
        this.normalizerForm = normalizerForm;
    }

    public <T> T parse(InputStream stream) throws IOException, ParseException {
        if (stream.markSupported()) {
            stream.mark(stream.available());
        }
        return this.parseXml(stream, stream.available(), "UTF8", this.normalizerForm);
    }

    private <T> T parseXml(InputStream stream, int available, String utf8, Normalizer.Form normalizerForm) throws IOException, ParseException {
        int bufferSize = this.bufferSize(available);
        PlistParserJavaCC parser = new PlistParserJavaCC(stream, utf8, bufferSize);
        parser.setNormalizerForm(normalizerForm);
        return (T)parser.parse();
    }

    public <T> T parse(Reader reader) throws IOException, ParseException {
        return this.parseXml(reader);
    }

    private <T> T parseXml(Reader reader) throws ParseException {
        PlistParserJavaCC parser = new PlistParserJavaCC(reader);
        parser.setNormalizerForm(this.normalizerForm);
        return (T)parser.parse();
    }

    public <T> T parse(File file) throws IOException, ParseException {
        return this.parseXml(file);
    }

    private <T> T parseXml(File file) throws IOException, ParseException {
        return this.parseXml(new FileInputStream(file), Long.valueOf(file.length()).intValue(), "UTF-8", this.normalizerForm);
    }

    protected int bufferSize(int proposedBufferSize) {
        int minimumBufferSize = Math.max(4096, proposedBufferSize);
        int maximumBufferSize = Math.min(minimumBufferSize, 0x1400000);
        return maximumBufferSize;
    }
}

