/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.tools;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.ValidationInfo;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.Verifier;
import com.apple.jingle.leghorn.fileformat.exceptions.UnknownTypeException;
import com.apple.jingle.leghorn.fileformat.exceptions.VerifierNotFoundException;
import com.apple.jingle.leghorn.fileformat.impl.ValidationsCollector;
import com.apple.jingle.leghorn.fileformat.impl.VerifierBuilder;
import com.apple.jingle.leghorn.quicktime.QuickTimeFile;
import com.apple.jingle.leghorn.quicktime.QuickTimeParser;
import com.apple.jingle.leghorn.quicktime.QuickTimeValidationContext;
import com.apple.jingle.leghorn.quicktime.SampleTimeStats;
import com.apple.jingle.leghorn.quicktime.atoms.MediaAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaInformationAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MovieAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleTableAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleToTimeAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackAtom;
import com.apple.jingle.leghorn.quicktime.exporters.VideoTrackSampleExporter;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class VideoFrameExporter
implements VideoTrackSampleExporter.Delegate {
    private String filenameFormat;
    private File movie;
    private File exportDirectory;
    private double frequency;
    private double height;
    private double width;
    private long imageCount;
    private Verifier verifier;
    private ContainerType containerType;
    protected static final Logger LOG = Logger.getLogger(VideoTrackSampleExporter.class);

    public VideoFrameExporter(File movie, File exportDirectory, String filenameFormat) {
        this.movie = movie;
        this.exportDirectory = exportDirectory;
        this.filenameFormat = filenameFormat;
        try {
            this.verifier = Verifier.getVerifier("assetmanager");
            this.containerType = this.verifier.getContainerTypeFactory().getTypeForMimeType("image/jpeg");
        }
        catch (UnknownTypeException e) {
            e.printStackTrace();
        }
        catch (VerifierBuilder.UnableToBuildVerifierException e) {
            e.printStackTrace();
        }
    }

    public String getFrequencyInSeconds() {
        return Double.toString(this.frequency);
    }

    public String getHeight() {
        return Double.toString(this.height);
    }

    public String getWidth() {
        return Double.toString(this.width);
    }

    public String getImageCount() {
        return Long.toString(this.imageCount);
    }

    public void export() throws IOException, URISyntaxException {
        QuickTimeParser parser = new QuickTimeParser();
        QuickTimeValidationContext ctx = new QuickTimeValidationContext(this.movie.getName());
        QuickTimeFile file = parser.parseFile((LeghornValidationContext)ctx, new URI("file://" + this.movie));
        SeekableDataInput sdi = SeekableDataInput.Factory.fromURI((URI)new URI("file://" + this.movie));
        MovieAtom movieAtom = file.findMovieAtom();
        List<TrackAtom> tracks = movieAtom.findChildrenOfType(TrackAtom.class, false);
        boolean hasExportedFrames = false;
        for (TrackAtom track : tracks) {
            TrackAtom.Cursor trackAtomCursor = new TrackAtom.Cursor(track);
            MediaAtom.Cursor mediaAtomCursor = new MediaAtom.Cursor(trackAtomCursor.getMediaAtom());
            if (hasExportedFrames || !mediaAtomCursor.getHandlerReferenceAtom().getSubtype().equals("vide")) continue;
            if (!new SampleTableAtom.Cursor(new MediaInformationAtom.Cursor(mediaAtomCursor.getMediaInformationAtom()).getSampleTableAtom()).getSampleDescriptions().get(1).getDataFormat().equals("jpeg")) continue;
            long timeScale = mediaAtomCursor.getMediaHeaderAtom().getTimeScale();
            SampleTimeStats sampleTimeStats = new SampleTimeStats(new SampleTableAtom.Cursor(new MediaInformationAtom.Cursor(mediaAtomCursor.getMediaInformationAtom()).getSampleTableAtom()).getSampleToTimeAtom());
            this.frequency = 1.0 / ((double)timeScale / sampleTimeStats.getMean());
            this.imageCount = 0L;
            List<SampleToTimeAtom.TableEntry> sampleToTimeTable = new SampleTableAtom.Cursor(new MediaInformationAtom.Cursor(mediaAtomCursor.getMediaInformationAtom()).getSampleTableAtom()).getSampleToTimeAtom().getCountToTimeTable();
            for (SampleToTimeAtom.TableEntry te : sampleToTimeTable) {
                this.imageCount += te.getSampleCount();
            }
            this.width = trackAtomCursor.getTrackHeaderAtom().getWidth();
            this.height = trackAtomCursor.getTrackHeaderAtom().getHeight();
            VideoTrackSampleExporter exporter = new VideoTrackSampleExporter(parser, sdi, track);
            exporter.exportTrack(this);
            hasExportedFrames = true;
        }
        if (!hasExportedFrames) {
            throw new IllegalArgumentException("Unable to find a JPEG video track in the given movie: " + tracks);
        }
    }

    @Override
    public void didReadSample(SampleTableAtom.SampleCursor cursor, InputStream sampleStream) {
        String filename = String.format(this.filenameFormat, cursor.getSampleNumber());
        File outputFile = new File(this.exportDirectory, filename);
        try {
            FileOutputStream fos = new FileOutputStream(outputFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos, 131072);
            IOUtils.copyLarge((InputStream)sampleStream, (OutputStream)bos);
            IOUtils.closeQuietly((OutputStream)bos);
            ValidationsCollector validationProblems = new ValidationsCollector();
            boolean verified = this.verifier.verifyContainerType(outputFile, this.containerType, (ValidationListener)validationProblems);
            if (!verified) {
                LOG.error((Object)("Couldn't verify: " + filename));
                for (ValidationInfo error : validationProblems.getValidations()) {
                    LOG.error((Object)error.getUserString());
                }
            } else {
                LOG.info((Object)("Verified:  " + filename));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (NullPointerException npe) {
            throw new RuntimeException("Input or output stream was null.");
        }
        catch (VerifierNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

