/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.tools;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.exceptions.UnknownTypeException;
import com.apple.jingle.leghorn.fileformat.impl.ContainerContainerDescriberRunner;
import com.apple.jingle.leghorn.fileformat.impl.VerifierBuilder;
import com.apple.jingle.leghorn.fileformat.impl.VersionedContainerTool;
import com.apple.jingle.leghorn.quicktime.Container;
import com.apple.jingle.leghorn.quicktime.MPEG4Parser;
import com.apple.jingle.leghorn.quicktime.QuickTimeFile;
import com.apple.jingle.leghorn.quicktime.QuickTimeParser;
import com.apple.jingle.leghorn.quicktime.QuickTimeValidationContext;
import com.apple.jingle.leghorn.quicktime.atoms.ChunkOffset64Atom;
import com.apple.jingle.leghorn.quicktime.atoms.ChunkOffsetAtom;
import com.apple.jingle.leghorn.quicktime.atoms.HandlerReferenceAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaInformationAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleTableAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackHeaderAtom;
import com.apple.jingle.leghorn.timecode.CMTime;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterleaveChecker
implements VersionedContainerTool {
    public interleaveCheckResult check(URI inputFileURI, double minCheckTh) throws IOException, DescriptionException, VerifierBuilder.UnableToBuildVerifierException, UnknownTypeException {
        QuickTimeFile qtf;
        boolean didSeeNonPreloadChapterChunkSequence = false;
        UniformTypeIdentifier inputUTI = UniformTypeIdentifier.byFileName((String)inputFileURI.toString());
        if (inputUTI == null) {
            return null;
        }
        SeekableDataInput sdi = SeekableDataInput.Factory.fromURI((URI)inputFileURI);
        QuickTimeValidationContext ctx = new QuickTimeValidationContext(sdi.getFileName(), this.getToolName(), this.getToolVersion());
        if (UniformTypeIdentifier.PUBLIC_MPEG_4_VIDEO == inputUTI) {
            qtf = new MPEG4Parser(QuickTimeFile.Type.MPEG4).parseFile((LeghornValidationContext)ctx, sdi);
        } else if (UniformTypeIdentifier.COM_APPLE_QUICKTIME_MOVIE == inputUTI) {
            qtf = new QuickTimeParser(QuickTimeFile.Type.QuickTime).parseFile((LeghornValidationContext)ctx, sdi);
        } else {
            return null;
        }
        interleaveCheckResult result = new interleaveCheckResult();
        result.minCheckTh = minCheckTh;
        Map<Long, TrackAtom> trackIDToTrack = this.getMapTrackIdToTrack(qtf);
        result.trackCount = trackIDToTrack.size();
        if (result.trackCount < 2L) {
            result.setOneTrackResult();
            return result;
        }
        List<chunkInfo> chunkList = this.buildChunkList(qtf);
        Collections.sort(chunkList, new Comparator<chunkInfo>(){

            @Override
            public int compare(chunkInfo o1, chunkInfo o2) {
                if (o1.offset > o2.offset) {
                    return 1;
                }
                if (o1.offset < o2.offset) {
                    return -1;
                }
                return 0;
            }
        });
        HashMap<Long, chunkSeqInfo> chuckSeq = new HashMap<Long, chunkSeqInfo>();
        double seqMin = Double.MAX_VALUE;
        double seqMax = Double.MIN_VALUE;
        chunkSeqInfo lastChuckSeq = null;
        for (chunkInfo ci : chunkList) {
            double interleaveDistance;
            if (lastChuckSeq != null && lastChuckSeq.trackID == ci.trackID) {
                ++lastChuckSeq.chunkCount;
                lastChuckSeq.duration = lastChuckSeq.duration.add(ci.duration);
                lastChuckSeq.numSamples += ci.numSamples;
                lastChuckSeq.size += ci.size;
                continue;
            }
            if (chuckSeq.containsKey(ci.trackID)) {
                ArrayList aa = new ArrayList(chuckSeq.values());
                Collections.sort(aa, new Comparator<chunkSeqInfo>(){

                    @Override
                    public int compare(chunkSeqInfo o1, chunkSeqInfo o2) {
                        if (o1.offset > o2.offset) {
                            return 1;
                        }
                        if (o1.offset < o2.offset) {
                            return -1;
                        }
                        return 0;
                    }
                });
                result.chuckSeqResult.addAll(aa);
                ++result.interleavingPeriods;
                seqMin = Double.MAX_VALUE;
                seqMax = Double.MIN_VALUE;
                chuckSeq.clear();
            }
            seqMin = Math.min(seqMin, ci.firstSampleTime.asSeconds());
            seqMax = Math.max(seqMax, ci.firstSampleTime.asSeconds());
            if (chuckSeq.containsKey(ci.trackID)) {
                lastChuckSeq = (chunkSeqInfo)chuckSeq.get(ci.trackID);
            } else {
                lastChuckSeq = new chunkSeqInfo();
                lastChuckSeq.trackID = ci.trackID;
                lastChuckSeq.trackType = ci.trackType;
                lastChuckSeq.offset = ci.offset;
                lastChuckSeq.chunkCount = 1L;
                lastChuckSeq.duration = ci.duration;
                lastChuckSeq.firstSampleTime = ci.firstSampleTime;
                lastChuckSeq.numSamples = ci.numSamples;
                lastChuckSeq.size = ci.size;
                lastChuckSeq.isPreload = trackIDToTrack.get(lastChuckSeq.trackID).isPreload();
                lastChuckSeq.isChapter = trackIDToTrack.get(lastChuckSeq.trackID).isChapter();
                chuckSeq.put(lastChuckSeq.trackID, lastChuckSeq);
            }
            if (!lastChuckSeq.isPreload && !lastChuckSeq.isChapter) {
                didSeeNonPreloadChapterChunkSequence = true;
            }
            if (lastChuckSeq.isPreload || lastChuckSeq.isChapter) {
                lastChuckSeq.isNotWrittenAtBeginning = didSeeNonPreloadChapterChunkSequence;
                if (didSeeNonPreloadChapterChunkSequence) {
                    ++result.numMisplacedChunkSequences;
                }
            }
            if ((interleaveDistance = Math.max(Math.abs(seqMin - ci.firstSampleTime.asSeconds()), Math.abs(seqMax - ci.firstSampleTime.asSeconds()))) < 0.001) {
                interleaveDistance = 0.0;
            }
            result.maxDistance = Math.max(result.maxDistance, interleaveDistance);
            lastChuckSeq.timeDistance = interleaveDistance;
            boolean bl = lastChuckSeq.problemInterleave = interleaveDistance > minCheckTh;
            if (!(interleaveDistance > minCheckTh)) continue;
            ++result.numPosibleIncorrectInterleave;
        }
        return result;
    }

    String getMediaType(MediaAtom media) {
        HandlerReferenceAtom hdlrAtom = media.findChild(HandlerReferenceAtom.class, new Container.Searcher.Option[0]);
        return hdlrAtom.getSubtype();
    }

    private Map<Long, TrackAtom> getMapTrackIdToTrack(QuickTimeFile qtf) {
        HashMap<Long, TrackAtom> ret = new HashMap<Long, TrackAtom>();
        for (TrackAtom track : qtf.findMovieAtom().findChildrenOfType(TrackAtom.class, false)) {
            TrackHeaderAtom header = track.getTrackHeaderAtom();
            long trackID = header.getTrackId();
            ret.put(trackID, track);
        }
        return ret;
    }

    private List<chunkInfo> buildChunkList(QuickTimeFile qtf) {
        ArrayList<chunkInfo> chunkList = new ArrayList<chunkInfo>();
        for (TrackAtom track : qtf.findMovieAtom().findChildrenOfType(TrackAtom.class, false)) {
            TrackHeaderAtom header = track.getTrackHeaderAtom();
            long trackID = header.getTrackId();
            MediaAtom media = track.getMediaAtom();
            String trackType = this.getMediaType(media);
            MediaInformationAtom mediaInfo = media.getMediaInformationAtom();
            long trackTimeScale = media.getMediaHeaderAtom().getTimeScale();
            SampleTableAtom stblAtom = mediaInfo.findChild(SampleTableAtom.class, new Container.Searcher.Option[0]);
            SampleTableAtom.Cursor stblAtomCursor = new SampleTableAtom.Cursor(stblAtom);
            SampleTableAtom.SampleCursor sampleCursor = new SampleTableAtom.SampleCursor(stblAtom);
            ChunkOffsetAtom stco = Container.Searcher.findSingleChildOfType(ChunkOffsetAtom.class, true, false, true, stblAtom);
            if (stco == null) {
                stco = Container.Searcher.findSingleChildOfType(ChunkOffset64Atom.class, true, true, true, stblAtom);
            }
            long lastSeenChunk = Long.MIN_VALUE;
            while (sampleCursor.hasNextSample()) {
                chunkInfo ci;
                sampleCursor.nextSample();
                long cn = sampleCursor.getChunkNumber();
                if (lastSeenChunk != cn) {
                    lastSeenChunk = cn;
                    ci = new chunkInfo();
                    ci.trackID = trackID;
                    ci.trackType = trackType;
                    ci.offset = stco.getChunkOffset(cn);
                    ci.firstSampleTime = new CMTime(sampleCursor.getSampleTime(), trackTimeScale);
                    ci.duration = new CMTime(sampleCursor.getSampleDuration(), trackTimeScale);
                    ci.numSamples = 1L;
                    ci.size = sampleCursor.getSampleLength();
                    chunkList.add(ci);
                    continue;
                }
                ci = (chunkInfo)chunkList.get(chunkList.size() - 1);
                ci.duration = ci.duration.add(new CMTime(sampleCursor.getSampleDuration(), trackTimeScale));
                ++ci.numSamples;
                ci.size += sampleCursor.getSampleLength();
            }
        }
        return chunkList;
    }

    @Override
    public String getToolName() {
        return "FoghornLeghorn MOV/MPEG-4 InterleaveChecker";
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }

    public static void main(String[] args) throws Exception {
        InterleaveChecker checker = new InterleaveChecker();
        URI uri = ContainerContainerDescriberRunner.uriForString(args[0]);
        interleaveCheckResult result = checker.check(uri, 0.0);
        if (result == null) {
            System.out.println("InterleaveChecker failed");
        } else {
            double interleaveProblemPercent = 0.0;
            if (result.chuckSeqResult.size() > 0) {
                interleaveProblemPercent = (double)result.numPosibleIncorrectInterleave / (double)result.chuckSeqResult.size();
            }
            System.out.println(String.format("Track count:%d Interleaving periods: %d, Chunk sequences: %d, Possibly incorrect interleaving chunk sequences: %d (%.02f%%), Distance window: %.03f sec, Max distance: %.03f sec, Misplaced chunk sequences: %d", result.trackCount, result.interleavingPeriods, result.chuckSeqResult.size(), result.numPosibleIncorrectInterleave, 100.0 * interleaveProblemPercent, result.minCheckTh, result.maxDistance, result.numMisplacedChunkSequences));
            for (chunkSeqInfo si : result.chuckSeqResult) {
                System.out.println(si.toString());
            }
        }
    }

    public static class interleaveCheckResult {
        public List<chunkSeqInfo> chuckSeqResult = new ArrayList<chunkSeqInfo>();
        public double seqMin = Double.MAX_VALUE;
        public double seqMax = Double.MIN_VALUE;
        public double maxDistance = Double.MIN_VALUE;
        public long interleavingPeriods = 1L;
        public long numPosibleIncorrectInterleave = 0L;
        public long numMisplacedChunkSequences = 0L;
        public double minCheckTh = 0.0;
        public long trackCount = 0L;

        public void setOneTrackResult() {
            this.seqMin = 0.0;
            this.seqMax = 0.0;
            this.maxDistance = 0.0;
            this.interleavingPeriods = 0L;
            this.numPosibleIncorrectInterleave = 0L;
            this.numMisplacedChunkSequences = 0L;
        }
    }

    public static class chunkSeqInfo {
        public long trackID = 0L;
        public String trackType = "";
        public long chunkCount = 0L;
        public long offset = 0L;
        public boolean problemInterleave = false;
        public boolean isNotWrittenAtBeginning = false;
        public double timeDistance = 0.0;
        public boolean isPreload = false;
        public boolean isChapter = false;
        public CMTime firstSampleTime = CMTime.ZERO;
        public CMTime duration = CMTime.ZERO;
        public long numSamples = 0L;
        public long size = 0L;

        public void reset() {
            this.trackID = 0L;
            this.trackType = "";
            this.chunkCount = 0L;
            this.offset = 0L;
            this.problemInterleave = false;
            this.isNotWrittenAtBeginning = false;
            this.timeDistance = 0.0;
            this.isPreload = false;
            this.isChapter = false;
            this.firstSampleTime = CMTime.ZERO;
            this.duration = CMTime.ZERO;
            this.numSamples = 0L;
            this.size = 0L;
        }

        public String toString() {
            return "chunkSeqInfo{trackID=" + this.trackID + ", trackType='" + this.trackType + '\'' + ", chunkCount=" + this.chunkCount + ", numSamples=" + this.numSamples + ", size=" + this.size + ", offset=" + String.format("0x%08x", this.offset) + ", problemInterleave=" + this.problemInterleave + ", isPreload=" + this.isPreload + ", isChapter=" + this.isChapter + ", isNotWrittenAtBeginning=" + this.isNotWrittenAtBeginning + ", timeDistance=" + this.timeDistance + ", firstSampleTime=" + this.firstSampleTime.asSeconds() + ", duration=" + this.duration.asSeconds() + '}';
        }
    }

    class chunkInfo {
        public long trackID = 0L;
        public String trackType = "";
        public long offset = 0L;
        public CMTime firstSampleTime = CMTime.ZERO;
        public CMTime duration = CMTime.ZERO;
        public long numSamples = 0L;
        public long size = 0L;

        chunkInfo() {
        }

        public String toString() {
            return "chunkInfo{trackID=" + this.trackID + ", trackType='" + this.trackType + '\'' + ", offset=" + this.offset + ", numSamples=" + this.numSamples + ", firstSampleTime=" + this.firstSampleTime.asSeconds() + ", duration=" + this.duration.asSeconds() + '}';
        }
    }
}

