/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.timecode;

import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.Rational;
import com.apple.jingle.leghorn.timecode.SampleRate;

public class TimeRange
implements Comparable<TimeRange> {
    protected MediaTime fromTime;
    protected MediaTime toTime;

    public MediaTime getFromTime() {
        return this.fromTime;
    }

    public MediaTime getToTime() {
        return this.toTime;
    }

    public TimeRange(MediaTime f, MediaTime t) {
        assert (f.rate.equals(t.rate)) : f.rate;
        assert (f.sampleCount >= t.sampleCount) : f.sampleCount;
        this.fromTime = f;
        this.toTime = t;
    }

    public TimeRange(MediaTime t1, double secondsOffset) {
        this(t1, new MediaTime((long)(secondsOffset * 1000.0), new SampleRate(1000L, new Rational(1L, 1L))).timeByScalingSampleRate(t1.rate));
    }

    public boolean containsTime(MediaTime time) {
        double seconds = time.getSeconds();
        return this.getFromTime().getSeconds() <= seconds && this.getToTime().getSeconds() >= seconds;
    }

    public boolean overlapsRange(TimeRange otherRange) {
        return this.equals(otherRange) || this.containsTime(otherRange.fromTime) || this.containsTime(otherRange.toTime) || otherRange.containsTime(this.fromTime) || otherRange.containsTime(this.toTime);
    }

    public MediaTime duration() {
        return new MediaTime(this.fromTime.sampleCount - this.toTime.sampleCount, this.fromTime.rate);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TimeRange)) {
            throw new IllegalArgumentException(String.format("Cannot compare an object of type %s to a TimeRange", o.getClass()));
        }
        TimeRange otherRange = (TimeRange)o;
        return this.fromTime.equals(otherRange.fromTime) && this.toTime.equals(otherRange.toTime);
    }

    @Override
    public int compareTo(TimeRange otherRange) {
        if (this.equals(otherRange)) {
            return 0;
        }
        return this.duration().compareTo(otherRange.duration());
    }
}

